!=======================================================================
!     This subroutine gives ice thickness.

!     Hice = ice thickness (m)
!     init = initial conditions [1/2/3]
!              1: no initial land ice
!              2: restart from the previous run
!              3: ICE-4G reconstruction

!     based on code by: M. Yoshimori
!=======================================================================

      subroutine cidm_get_ice(iland,Hice)

#if defined ubc_cidm
! ... global
      USE global_param   ! dp,c0,nlon,nlat,init,ishelf,igrid
      implicit none

! ... subroutine arguments
      INTEGER,DIMENSION(1:nlon,1:nlat),INTENT(IN) :: iland
      REAL(KIND=dp),DIMENSION(1:nlon,1:nlat),INTENT(OUT) :: Hice

! ... local
      integer :: i,j
      CHARACTER(LEN=30) :: fname

      SELECT CASE(init)

!-----------------------------------------------------------------------
!       no initial ice
!-----------------------------------------------------------------------

        CASE(1)

          Hice = c0

!-----------------------------------------------------------------------
!       restart
!-----------------------------------------------------------------------

        CASE(2) ! now read in cidm_rest_read

!          fname='bism_data/rest_Hice.dta'
!          OPEN(UNIT=1,FILE=fname,STATUS='OLD',FORM='UNFORMATTED')
!          READ(1) i,j
!          READ(1) ((Hice(i,j),i=1,nlon),j=1,nlat)
!          CLOSE(UNIT=1)

!-----------------------------------------------------------------------
!       ICE-4G
!-----------------------------------------------------------------------

        CASE(3)

          fname='bism_data/ice4g21_Hice.dta'
          OPEN(UNIT=1,FILE=fname,STATUS='OLD',FORM='UNFORMATTED')
          READ(1) i,j
          READ(1) ((Hice(i,j),i=1,nlon),j=1,nlat)
          CLOSE(UNIT=1)

!-----------------------------------------------------------------------
!       error
!-----------------------------------------------------------------------

        CASE DEFAULT

          WRITE(*,*) 'error: is_load_Hice'
          WRITE(*,*) 'inappropriate value for init!'
          STOP

      end SELECT

      if (ishelf > 0) then   ! shelf-ice option
        WHERE (iland == -1) Hice = c0
      else
        WHERE (iland ==  0) Hice = c0
      endif

      WHERE (Hice < c0) Hice = c0
      WHERE (idomain == -1) Hice = c0

      call cidm_lbc_2d_real(Hice)

#endif
!=======================================================================
      end subroutine cidm_get_ice
!=======================================================================
