!=======================================================================
!     based on code by: M. Yoshimori
!=======================================================================

      subroutine cidm_input

      use global_param
!      implicit none

      character(len=30) :: fname

      integer ioun

      namelist /bism/ igrid, imass, iclim, itherm, itdcoup, itdptvar             &
     &,               istrn, idisc, idyn, islid, itrack, isilt, iheat            &
     &,                      ibedtd, isurf, ibedr, isubtop, igingembre                  &
     &,               isurfhyd, irebound, ishelf, ialbedo, init, nvert           &
     &,               nxi, nzeta, nvertb, nxibc, nxibf, ndepw, ncore             &
     &,               nducks, ntrack, nsilt, nsurf, nbedr, nsedtype              &
     &,               nbin, ntable, npddamp, ndepd, nhyps, ntisos, nvol          &
     &,               nsnap, delt, deltt, deltg, deltb, delth, hydnest           &
     &,               themin, themax, phimin, phimax, delthed, delphid           &
     &,               aa, expcalf, kcalf, dtvol, dtsnap, dtrest

      fname = 'control.in'

      igrid = 1                 ! igrid (1-8) - model domain (NA/EISMINT/Anta, etc.)
      imass = 1                 ! imass (1/2/3/4/5/6) - mass balance treatment
      iclim = 3          ! iclim (1/2/3/4/5/6) - climate data type
      itherm = 0         ! itherm (0/1) - ice thermodynamics
      itdcoup = 0        ! itdcoup (0/1) - thermomechanical coupling
      itdptvar = 0       ! itdptvar (0/1) - temperature-dependent thermal parameters
      istrn = 2          ! istrn (1/2) - strain heating discretization
      idisc = 4          ! idisc (3/4/5) - vertical differencing treatment, ice TD
      idyn = 2           ! idyn (1/2) - ice dynamics treatment (numerical)
      islid = 0          ! islid (0/1) - basal sliding treatment (sheet ice)
      itrack = 0         ! itrack (0/1) - particle tracking
      isilt = 0          ! isilt (0/1) - basal debris treatment
      iheat = 1          ! iheat (1/2) - geothermal heat treatment
      ibedtd = 0         ! ibedtd (0/1/2) - bed thermodynamics treatment
      isurf = 0          ! isurf (0/1/2) - surface geology treatment
      ibedr = 0          ! ibedr (0/1/2) - bedrock geology treatment
      isubtop = 0        ! isubtop (0/1/2/3) - subgrid topographic treatment
      igingembre = 0     ! igingembre (0/1/2) - surface hydrology treatment
      isurfhyd = 0       ! isurfhyd (0/1/2) - surface water flux treatment
      irebound = 1       ! irebound (0/1) - isostatic compensation
      ishelf = 0         ! ishelf (0/1/2) - floating ice and calving treatment
      ialbedo = 0        ! ialbedo (0/1) - Susan Marshall snow-albedo model
      init = 1           ! init (1/2/3) - initiation or continuation run

      nvert = 1          ! nvert - vertical (z) grid dimension (physical)
      nxi = 1                 ! nxi - transformed vertical grid dimension, ice TD
      nzeta = 1          ! nzeta - transformed vertical grid dimension, ice dynamics
      nvertb = 1         ! nvertb - crustal grid dimension
      nxibc = 1          ! nxibc - lower (unfrozen) crust grid dimension
      nxibf = 1          ! nxibf - upper (frozen) crust grid dimension
      ndepw = 5          ! ndepw - dependencies in water sheet eqns
      ncore = 1210       ! ncore - length of ice core climate proxy time series
      nducks = 1000      ! nducks - number of subglacial particle tracers
      ntrack = 6         ! ntrack - positional (r-t) tracking variables for ducks
      nsilt = 2          ! nsilt - geologic debris units
      nsurf = 29         ! nsurf - number of surficial materials
      nbedr = 4          ! nbedr - number of bedrock materials
      nsedtype = 3       ! nsedtype - sediment `type' divisions
      nbin = 36          ! nbin - directional bins for striae
      ntable = 600       ! ntable - temperature entries, PDD lookup table
      npddamp = 60       ! npddamp - amplitude entries, PDD lookup table
      ndepd = 9          ! ndepd - dependencies in dynamical eqns
      nhyps = 8          ! nhyps - number of subgrid hypsometry weights
      ntisos = 1         ! ntisos
      nvol = 4000        ! nvol - maximum array for ice volume
      nsnap = 100        ! nsnap - maximum number of snapshot

      delt = 1.          ! delt - dynamics time step (years)
      deltt = 10.        ! deltt - thermodynamics time step (years)
      deltg = 100.       ! deltg - geological output time step (years)
      deltb = 1.         ! deltb - bed thermodynamics time step (years)
      delth = 1800.      ! delth - surface hydrology time step, inner loop (seconds)
      hydnest = 100.     ! hydnest - nested solution time for hydrology soln (years)
      themin = -90.      ! themin
      themax = 90.       ! themax
      phimin = -3.6      ! phimin
      phimax = 363.6     ! phimax
      delthed = 1.8      ! delthed
      delphid = 3.6      ! delphid
      aa = 0.95          ! aa - dynamical grid transformation parameter
      expcalf = 10.      ! expcalf - decay rate for calving (exp with T)
      kcalf =  4.        ! kcalf - calving coefficient
      dtvol = 1.         ! dtvol - interval for ice volume calculation
      dtsnap = 1.        ! dtsnap   - snapshot output interval
      dtrest = 1.        ! dtrest   - restart file output interval

      call getunit (ioun, fname, 'f s r')
      read  (ioun, bism, end=100)
100   continue
      write (*, bism)
      call relunit (ioun)

!=======================================================================
      end subroutine cidm_input
!=======================================================================
