!************************************************************************
!   Updates isostatic earth depression based on simple harmonic
!   (viscous) oscillator model with characteristic mantle response
!   time tau.  Parabolic equation, solved implicitly at each
!   point hg(i,j).  I use the bulk ice thickness H_b = aH_s+(1-a)H_c.

    subroutine cidm_isos(hg0,hg,hi,Hice,Hicekt,dhgdt,hgk,hgkt,hik,hikt,&
                    load,vert,loadscale,alinear,aquad,bquad,curvature,&
                    time_maxwell,hg_maxwell,iglacial,ifloating,iland)

!************************************************************************
      USE subgrid_arrays
      USE hydrol_arrays
      implicit none
      INTEGER, DIMENSION(nlon,nlat), INTENT(IN) :: iglacial,ifloating,iland
      REAL(dp), DIMENSION(nlon,nlat), INTENT(IN) :: Hice,Hicekt,hg0
      REAL(dp), DIMENSION(nlat), INTENT(IN) :: loadscale
      REAL(dp), DIMENSION(0:200,0:ntisos+1), INTENT(IN) :: vert
      REAL(dp), DIMENSION(nlon,nlat), INTENT(INOUT) :: dhgdt,hg,hi,&
                                                       hgk,hgkt,hik,hikt,&
                                                       alinear,aquad,&
                                                       bquad,curvature
      REAL(dp), DIMENSION(0:ntisos,nlon,nlat), INTENT(INOUT) :: load
      REAL(dp), DIMENSION(0:2), INTENT(INOUT) :: time_maxwell
      REAL(dp), DIMENSION(0:2,nlon,nlat), INTENT(INOUT) :: hg_maxwell

      ! Local variables
      integer :: i,j,k,nt,nthist
      REAL(dp) :: coimp,coexp,hicur,hiprev,Hnet,Hnew,Hprev,delhsub,coeff
      REAL(dp) :: marine_load,ice_load,net_load,lake_load
      LOGICAL :: lfloat

!************************************************************************
      ! Branch between full Maxwellan spherical Earth response or
      ! simple, locally-damped response

!************************************************************************
      if (irebound == 1) then                ! Local visco-elastic response

        coimp = c1 + delt/(c2*tau)
        coexp = c1 - delt/(c2*tau)

        ! Account for changing ocean load
        marine_load = sealevel*rhow/rhoe

!************************************************************************
        if (isubtop == 2) then                ! Account for subgrid buildup
          do j=3,nlatp
            do i=3,nlonp
              lfloat = .false.
              if ((iglacial(i,j)==0).and.(icesub(nhyps,i,j) > c0)) then
                ! Subgrid ice
                Hnet = Heff(i,j)
                if ((hg(i,j) + Hnet) < iceberg*Hnet) lfloat = .true.
              else                                ! Glaciated cell
                Hnet = Hice(i,j)
                if (ifloating(i,j) == 1) lfloat = .true.
              endif
              if (.not.(lfloat) .and. (Hnet > c0)) then
                ice_load = Hnet*rhoi/rhoe
                if (hg0(i,j) < c0) then                ! was once submerged
                  ice_load = ice_load + hg0(i,j)*rhow/rhoe    ! reduce
                endif
                marine_load = c0
              else
                ice_load = c0
                if (hg(i,j) < MAX(sealevel,c0)) then          ! submerged
                  if (hg0(i,j) < MAX(sealevel,c0)) then     ! initially doused
                    marine_load = (hg0(i,j)-hg(i,j) + sealevel)*rhow/rhoe
                  else                                            ! initially land
                    marine_load = (-hg(i,j) + sealevel)*rhow/rhoe
                  endif
                else
                  marine_load = c0
                endif
              endif
              net_load = ice_load + marine_load

              if (igingembre > 0) then                        ! proglacial lakes
                if ((ilake(i,j) == 1) .and. (hg(i,j) < sealevel)) then
                  ! incremental lake load, if lake is higher than sea level
                  lake_load = rhow/rhoe*(swater(i,j)+hg(i,j)-sealevel)
                  net_load = net_load + lake_load
                endif
              endif

              hg(i,j) = (coexp*hgk(i,j) + delt/tau*(hg0(i,j)-net_load))/coimp
              hi(i,j) = hg(i,j) + Hnet

            enddo
          enddo

!************************************************************************
        else                                ! Not subgrid modelling
          coeff = delt/(c2*tau)
          do j=1,nlat
            do i=1,nlon
              ice_load = c0
              marine_load = c0
              if ((idomain(i,j) == 1).and.(iland(i,j) == 1)) then
                ice_load = Hice(i,j)*rhoi/rhoe
                net_load = ice_load + marine_load
                hg(i,j) = ((c1 - coeff)*hgk(i,j) &
                           - c2*coeff*(net_load - hg0(i,j)))/(c1 + coeff)
              endif
            enddo
          enddo
          call cidm_get_surf(iland,hg,Hice,ifloating,hi)
          call cidm_lbc_2d_real(hg)
          call cidm_lbc_2d_real(hi)
        endif

!          do j=3,nlatp
!            do i=3,nlonp
!              if ((Hice(i,j) > c0) .and. (ifloating(i,j) == 0)) then
!                ice_load = Hice(i,j)*rhoi/rhoe
!                if (hg0(i,j) < c0) then                ! was once submerged
!                  ice_load = ice_load + hg0(i,j)*rhow/rhoe    ! reduce
!                endif
!                marine_load = c0
!              else
!                ice_load = c0
!                if (hg(i,j) < MAX(sealevel,c0)) then          ! submerged
!                  if (hg0(i,j) < MAX(sealevel,c0)) then     ! initially doused
!                    marine_load = (hg0(i,j)-hg(i,j) + sealevel)*rhow/rhoe
!                  else                                            ! initially land
!                    marine_load = (-hg(i,j) + sealevel)*rhow/rhoe
!                  endif
!                else
!                  marine_load = c0
!                endif
!              endif
!              net_load = ice_load + marine_load

!              if (igingembre > 0) then                        ! proglacial lakes
!                if ((ilake(i,j) == 1) .and. (hg(i,j) < sealevel)) then
!                  ! incremental lake load, if lake is higher than sea level
!                  lake_load = rhow/rhoe*(swater(i,j)+hg(i,j)-sealevel)
!                  net_load = net_load + lake_load
!                endif
!              endif

!              hg(i,j) = (coexp*hgk(i,j) + delt/tau*(hg0(i,j)-net_load))/coimp
!              hi(i,j) = hg(i,j) + Hice(i,j)

!              endif
!            enddo
!          enddo

        ! Basal motion
        dhgdt = (hg - hgk)/deltb

!************************************************************************
!************************************************************************
      elseif (irebound == 2) then        ! Maxwell Earth response

        ! Check if time for the full Maxwell solution (1000-yr intervals)
        if (MOD(ctime,deltb) == c0) then

          ! Update the load history
          nthist = MIN(ntisos, INT((ctime-stime)/deltb))
          do j=3,nlatp
            do i=3,nlonp
              do nt=nthist,1,-1                       ! bump down old loads
                load(nt,i,j) = load(nt-1,i,j)
              enddo
            enddo
          enddo

          ! Current load, including ice, ocean, and proglacial lake changes
          if (isubtop == 2) then                ! Account for subgrid buildup
            do j=3,nlatp
              do i=3,nlonp
                lfloat = .false.
                if ((iglacial(i,j)==0).and.(icesub(nhyps,i,j) > c0)) then
                  ! Subgrid ice
                  Hnet = Heff(i,j)
                  if ((hg(i,j) + Hnet) < iceberg*Hnet) lfloat = .true.
                else                                ! Glaciated cell
                  Hnet = Hice(i,j)
                  if (ifloating(i,j) == 1) lfloat = .true.
                endif
                if (.not.(lfloat) .and. (Hnet > c0)) then
                  ice_load = Hnet
                  if (hg0(i,j) < c0) then                ! was once submerged
                    ice_load = ice_load + hg0(i,j)*rhow/rhoi    ! reduce
                  endif
                  marine_load = c0
                else
                  ice_load = c0
                  if (hg(i,j) < MAX(sealevel,c0)) then          ! submerged
                    if (hg0(i,j) < MAX(sealevel,c0)) then   ! initially doused
                      marine_load = (hg0(i,j)-hg(i,j) + sealevel)*rhow/rhoe
                    else                                    ! initially land
                      marine_load = (-hg(i,j) + sealevel)*rhow/rhoe
                    endif
                  else
                    marine_load = c0
                  endif
                endif
                net_load = ice_load + marine_load

                if (igingembre > 0) then                ! proglacial lakes
                  if ((ilake(i,j) == 1) .and. (hg(i,j) < sealevel)) then
                    ! incremental lake load, if lake is higher than sea level
                    lake_load = rhow/rhoe*(swater(i,j)+hg(i,j)-sealevel)
                    net_load = net_load + lake_load
                  endif
                endif

                load(0,i,j) = net_load*loadscale(j)     ! current load

              enddo
            enddo

!--------------------------------------------------------------------------
          else                                ! Large-scale modelling
            do j=3,nlatp
              do i=3,nlonp
                if ((Hice(i,j) > c0) .and. (ifloating(i,j) == 0)) then
                  ice_load = Hice(i,j)
                  if (hg0(i,j) < c0) then                ! was once submerged
                    ice_load = ice_load + hg0(i,j)*rhow/rhoi    ! reduce
                  endif
                  marine_load = c0
                else
                  ice_load = c0
                  if (hg(i,j) < MAX(sealevel,c0)) then          ! submerged
                    if (hg0(i,j) < MAX(sealevel,c0)) then   ! initially doused
                      marine_load = (hg0(i,j)-hg(i,j) + sealevel)*rhow/rhoe
                    else                                    ! initially land
                      marine_load = (-hg(i,j) + sealevel)*rhow/rhoe
                    endif
                  else
                    marine_load = c0
                  endif
                endif
                net_load = ice_load + marine_load

                if (igingembre > 0) then                ! proglacial lakes
                  if ((ilake(i,j) == 1) .and. (hg(i,j) < sealevel)) then
                    ! incremental lake load, if lake is higher than sea level
                    lake_load = rhow/rhoe*(swater(i,j)+hg(i,j)-sealevel)
                    net_load = net_load + lake_load
                  endif
                endif

                load(0,i,j) = net_load*loadscale(j)     ! current load

              enddo
            enddo
          endif            ! isubtop ifblock

          ! Call isostatic update module

#if !defined uvic_embm
          call isos_maxwell(hg,hg0,load,vert,loadscale,time)
#endif
!*************************************************************************
        else                ! Extrapolate isostatic evolution between
                        ! full Maxwell Earth solutions, using the local
                        ! bed elevations from the three previous full
                        ! solutions and a quadratic extrapolator.
#if !defined uvic_embm
          call extrapolate_maxwell(hg,load,alinear,aquad,bquad,curvature,&
                                   time_maxwell,hg_maxwell,time)
#endif
        endif                ! update timecheck ifblock

        dhgdt = (hg - hgk)/100.0_dp

!*************************************************************************
      endif              ! irebound ifblock
!*************************************************************************
      ! Update
      hgk = hg                          ! For next isostatic adjustment

      ! Remove isostatic component from ice dynamics
      hik = hi

      ! Adjust isostatic component for ice thermodynamics
      hgkt = hg
      hikt = hgkt + Hicekt

      if (isubtop == 2) then                ! Account for subgrid buildup
        ! Adjust subgrid topography
        do j=1,nlat
          do i=1,nlon
            delhsub = dhgdt(i,j)*delt
            do k=1,nhyps
              hsub(k,i,j) = hsub(k,i,j) + delhsub
            enddo
           enddo
        enddo
      endif

!***************************************************************************
    end subroutine cidm_isos
!***************************************************************************
