!=======================================================================
!     This module declares arrays for use in surface mass balance.

!     based on code by: M. Yoshimori
!=======================================================================

      MODULE cidm_mod_mass

#if defined ubc_cidm
      USE global_param   ! dp,c3,c5
      implicit none
      SAVE

!-----------------------------------------------------------------------
!     degree-day method
!       ddfice       : degree-day factor for ice  (m/pdd w.e.)
!       ddfsnow      : degree-day factor for snow (m/pdd w.e.)
!       refreeze_min : min refreezing ratio for alpine glaciers
!       refreeze_max : max refreezing ratio for ice sheet
!       tvar         : Gaussian variance (deg C)
!       cutoff       : cutoff temperature (deg C)
!-----------------------------------------------------------------------

      REAL(KIND=dp),PARAMETER :: ddfice  = 0.008_dp
      REAL(KIND=dp),PARAMETER :: ddfsnow = 0.003_dp
      REAL(KIND=dp),PARAMETER :: refreeze_min = 0.07_dp
      REAL(KIND=dp),PARAMETER :: refreeze_max = 0.6_dp
      REAL(KIND=dp),PARAMETER :: tvar = c5
      REAL(KIND=dp),PARAMETER :: cutoff = c3*tvar

!-----------------------------------------------------------------------
!     direct method
!       s_ann: annual mean snow (m/year w.e.)
!       m_ann: annual mean surface melting (m/year w.e.)
!       r_ann: annual mean rain (m/year w.e.)
!-----------------------------------------------------------------------

      REAL(KIND=dp),ALLOCATABLE,DIMENSION(:,:),SAVE :: &
        s_ann,&
        m_ann,&
        r_ann

!-----------------------------------------------------------------------
!     degree-day method
!       p_mon: monthly mean precipitation (m/month w.e.)
!       t_mon: monthly mean temperature (K)
!       p_ann: annual mean precipitation (m/month w.e.)
!       t_ann: annual mean temperature (K)
!-----------------------------------------------------------------------

      REAL(KIND=dp),ALLOCATABLE,DIMENSION(:,:,:),SAVE :: &
        p_mon,&
        t_mon

      REAL(KIND=dp),ALLOCATABLE,DIMENSION(:,:),SAVE :: &
        p_ann,&
        t_ann

#endif
!=======================================================================
      end MODULE cidm_mod_mass
!=======================================================================
