!=======================================================================
!     output routine for Basic Ice Sheet Model

!     based on code by: M. Yoshimori and A. Schmittner
!=======================================================================

      subroutine cidm_snap_writ(sum_calv)

#if defined ubc_cidm
! ... global
      USE global_vars   ! dp,nlon,nlat,lon,lat,isnap,nsnap,itime,istart
                        ! idsnap,hg,Hice,hi
      implicit none

! ... local
      integer :: i,j,im1,jm1,ios
      INTEGER,DIMENSION(1:nlon,1:nlat) :: kmt
      REAL(KIND=dp),DIMENSION(1:nlon,1:nlat) :: sum_calv
      CHARACTER(LEN=8) :: fsnap
      CHARACTER(LEN=3) :: a3

      if (isnap <= nsnap) then

!-----------------------------------------------------------------------
!       create a new snapshot file name
!-----------------------------------------------------------------------

        fsnap(1:8) = 'sice.000'
        WRITE(a3,'(i3)') isnap
        fsnap(8:8) = a3(3:3)
        if (isnap >= 10)  fsnap(7:8) = a3(2:3)
        if (isnap >= 100) fsnap(6:8) = a3(1:3)

!-----------------------------------------------------------------------
!       read basic geometric information
!-----------------------------------------------------------------------

        OPEN(UNIT=1,FILE='bism_data/bism_kmt.dta',STATUS='OLD',&
             FORM='UNFORMATTED')
        READ(1) i,j
        READ(1) ((kmt(i,j),i=1,nlon),j=1,nlat)
        CLOSE(UNIT=1)

!-----------------------------------------------------------------------
!       write land ice snapshot
!-----------------------------------------------------------------------

        call getunit (ios, fsnap, 'u s r ieee')

        WRITE (ios) nlon,nlat
        WRITE (ios) lon
        WRITE (ios) lat
        WRITE (ios) kmt
        WRITE (ios) SNGL(hg)
        WRITE (ios) SNGL(Hice)
        WRITE (ios) SNGL(hi)
        WRITE (ios) SNGL(balance) ! surface mass balance in m/yr
        WRITE (ios) SNGL(sum_calv) ! calving rate m/yr

        call relunit (ios)

!-----------------------------------------------------------------------
!       create a new time-averaged data output file name
!-----------------------------------------------------------------------

!       fsnap(1:8) = 'tice.000'
!       WRITE(a3,'(i3)') isnap
!       fsnap(8:8) = a3(3:3)
!       if (isnap >= 10)  fsnap(7:8) = a3(2:3)
!       if (isnap >= 100) fsnap(6:8) = a3(1:3)

!-----------------------------------------------------------------------
!       write land ice time-averaged data
!-----------------------------------------------------------------------

!       call getunit (ios, fsnap, 'u s r ieee')

!       WRITE (ios) nlon,nlat
!       WRITE (ios) lon
!       WRITE (ios) lat
!       WRITE (ios) kmt
!       WRITE (ios) SNGL(ta_hg)
!       WRITE (ios) SNGL(ta_Hice)
!       WRITE (ios) SNGL(ta_hi)
!       WRITE (ios) SNGL(ta_balance)

!       call relunit (ios)

        isnap = isnap + 1

      endif

#endif
!=======================================================================
      end subroutine cidm_snap_writ
!=======================================================================
