!=======================================================================
!     Bilinear interpolation

!     reference: Numerical Receipe, p.116,117

!     based on code by: M. Yoshimori
!=======================================================================

      subroutine cidm_tool_interp(nx1,ny1,x1,y1,data1,&
                                  nx2,ny2,x2,y2,data2,spval)

      implicit none

      INTEGER,PARAMETER :: dp = 8
      REAL(KIND=dp),PARAMETER :: c1 = 1._dp
      INTEGER,INTENT(IN) :: nx1,ny1,nx2,ny2
      REAL(KIND=dp),DIMENSION(1:nx1),INTENT(IN) :: x1
      REAL(KIND=dp),DIMENSION(1:ny1),INTENT(IN) :: y1
      REAL(KIND=dp),DIMENSION(1:nx2),INTENT(IN) :: x2
      REAL(KIND=dp),DIMENSION(1:ny2),INTENT(IN) :: y2
      REAL(KIND=dp),DIMENSION(1:nx1,1:ny1),INTENT(IN) :: data1
      REAL(KIND=dp),INTENT(IN) :: spval
      REAL(KIND=dp),DIMENSION(1:nx2,1:ny2),INTENT(OUT) :: data2

      integer :: i,j,k,l
      REAL(KIND=dp) :: a1,a2,a3,a4,t,u

      data2 = spval

      do i=1,ny2
        do j=1,ny1-1
          if ((y2(i) >= y1(j)).and.(y2(i) <= y1(j+1))) then
            do k=1,nx2
              do l=1,nx1-1
                if ((x2(k) >= x1(l)).and.(x2(k) <= x1(l+1))) then

                  a1 = data1(l,j)
                  a2 = data1(l+1,j)
                  a3 = data1(l+1,j+1)
                  a4 = data1(l,j+1)

                  t = (x2(k)-x1(l)) / (x1(l+1)-x1(l))
                  u = (y2(i)-y1(j)) / (y1(j+1)-y1(j))

                  data2(k,i) = (c1-t)*(c1-u)*a1 + t*(c1-u)*a2 + t*u*a3 &
                              + (c1-t)*u*a4

                  if (data1(l,j) == spval         &
                      .or.data1(l+1,j) == spval   &
                      .or.data1(l+1,j+1) == spval &
                      .or.data1(l,j+1) == spval)  &
                    data2(k,i)=spval
                endif
              enddo
            enddo
          endif
        enddo
      enddo

!=======================================================================
      end subroutine cidm_tool_interp
!=======================================================================

!=======================================================================
!     Fill in missing data based on code by W. Lee

!     based on code by: M. Yoshimori
!=======================================================================

      subroutine cidm_tool_fill(nx,ny,a,spval)

      implicit none
      INTEGER,PARAMETER :: dp = 8
      REAL(KIND=dp),PARAMETER :: c0 = 0._dp

! ... subroutine arguments
      INTEGER,INTENT(IN) :: nx,ny
      REAL(KIND=dp),INTENT(INOUT),DIMENSION(1:nx*ny) :: a
      REAL(KIND=dp),INTENT(IN) :: spval

! ... local
      integer :: i,j,ii,jj,i1,i2,nsum,nfix
      REAL(KIND=dp) :: sum
      REAL(KIND=dp),DIMENSION(1:3,1:3) :: ind

      DO
        nfix = 0
        do j = 1,ny
          do i = 1,nx
            ind(2,2) = (j-1)*nx + i

!-----------------------------------------------------------------------
!           If point in question is ok, skip to next point.
!-----------------------------------------------------------------------

            if (a(ind(2,2)) < 1.E30) CYCLE

            ind(1,2) = ind(2,2) - 1
            ind(3,2) = ind(2,2) + 1

            ind(1,1) = ind(1,2) - nx
            ind(2,1) = ind(2,2) - nx
            ind(3,1) = ind(3,2) - nx

            ind(1,3) = ind(1,2) + nx
            ind(2,3) = ind(2,2) + nx
            ind(3,3) = ind(3,2) + nx

            if (i == 1) then
               ind(1,2) = j * nx  - 1
               ind(1,1) = ind(1,2) - nx
               ind(1,3) = ind(1,2) + nx
            endif

            if (i == nx) then
               ind(3,2) = (j-1) * nx + 1
               ind(3,1) = ind(3,2)    - nx
               ind(3,3) = ind(3,2)    + nx
            endif

            sum  = c0
            nsum = 0

            do jj = 1,3
               if ((jj == 1).and.(j == 1)) CYCLE
               if ((jj == 3).and.(j == ny)) CYCLE
               do ii = 1,3
                  if ((ii == 2).and.(jj == 2)) CYCLE
                  if (a(ind(ii,jj)) > 1.E30) CYCLE
                  sum  = sum  + a(ind(ii,jj))
                  nsum = nsum + 1
               enddo
            enddo

            if (nsum >= 3) a(ind(2,2)) = sum / DBLE(nsum)
            nfix = nfix + 1

          enddo
        enddo

        if (nfix == 0) EXIT
      enddo

!=======================================================================
      end subroutine cidm_tool_fill
!=======================================================================

!=======================================================================
!     Convert 2D array matrix into 1D array vector

!     based on code by: M. Yoshimori
!=======================================================================

      subroutine cidm_tool_convert1d(nx,ny,matrix,vector)

      implicit none
      INTEGER,PARAMETER :: dp = 8

! ... subroutine arguments
      INTEGER,INTENT(IN) :: nx,ny
      REAL(KIND=dp),INTENT(IN),DIMENSION(1:nx,1:ny) :: matrix
      REAL(KIND=dp),INTENT(OUT),DIMENSION(1:nx*ny) :: vector

! ... local
      integer :: i,j,k

      do j = 1,ny
        do i = 1,nx
          k = nx*(j-1) + i
          vector(k) = matrix(i,j)
        enddo
      enddo

!=======================================================================
      end subroutine cidm_tool_convert1d
!=======================================================================

!=======================================================================
!     Convert 1D array vector into 2D array matrix

!     based on code by: M. Yoshimori
!=======================================================================

      subroutine cidm_tool_convert2d(nx,ny,vector,matrix)

      implicit none
      INTEGER,PARAMETER :: dp = 8

! ... subroutine arguments
      INTEGER,INTENT(IN) :: nx,ny
      REAL(KIND=dp),INTENT(IN),DIMENSION(1:nx*ny) :: vector
      REAL(KIND=dp),INTENT(OUT),DIMENSION(1:nx,1:ny) :: matrix

! ... local
      integer :: i,j,k

      do j = 1,ny
        do i = 1,nx
          k = nx*(j-1) + i
          matrix(i,j) = vector(k)
        enddo
      enddo

!=======================================================================
      end subroutine cidm_tool_convert2d
!=======================================================================
