!=======================================================================
!     This subroutine calculates ice volume.

!     vol_SH: total ice volume in the Southern Hemisphere (m^3)
!     vol_NH: total ice volume in the Northern Hemisphere (m^3)

!     based on code by: M. Yoshimori
!=======================================================================

      subroutine cidm_vol_calc(Hice,vol_SH,vol_NH)

! ... global
      USE global_param   ! dp,c0,nlon,nlat,nvol,itime,idvol,igrid,area
      implicit none

! ... subroutine arguments
      REAL(KIND=dp),DIMENSION(1:nlon,1:nlat),INTENT(INOUT) :: Hice
      REAL(KIND=dp),DIMENSION(1:nvol),INTENT(INOUT) :: vol_SH,vol_NH

! ... local
      integer :: ivol,neq,i,j

      ivol = INT(ctime/dtvol) + 1

!-----------------------------------------------------------------------
!     check 'Hice' values
!-----------------------------------------------------------------------

      call cidm_lbc_2d_real(Hice)
      WHERE (Hice < c0) Hice = c0

!-----------------------------------------------------------------------
!     set some constants
!-----------------------------------------------------------------------

      if (MOD(nlat,2) == 0) then
        neq = nlat/2
      else
        neq = (nlat+1)/2
      endif

!-----------------------------------------------------------------------
!     ice volume in the Southern Hemisphere, vol_SH (m^3)
!-----------------------------------------------------------------------

      vol_SH(ivol) = c0
      do j=1,neq
        do i=2,nlon-1
          vol_SH(ivol) = vol_SH(ivol) + Hice(i,j)*area(j)
        enddo
      enddo

!-----------------------------------------------------------------------
!     ice volume in the Northern Hemispere, vol_NH (m^3)
!-----------------------------------------------------------------------

      vol_NH(ivol) = c0
      do j=neq+1,nlat
        do i=2,nlon-1
          vol_NH(ivol) = vol_NH(ivol) + Hice(i,j)*area(j)
        enddo
      enddo

!=======================================================================
      end subroutine cidm_vol_calc
!=======================================================================

!=======================================================================
!     This subroutine writes ice volume.

!     vol_SH: total ice volume in the Southern Hemisphere (m^3)
!     vol_NH: total ice volume in the Northern Hemisphere (m^3)

!     based on code by: M. Yoshimori
!=======================================================================

      subroutine cidm_vol_writ(vol_SH,vol_NH)

! ... global
      USE global_param   ! dp,nlon,nlat,nvol
      implicit none

! ... subroutine arguments
      REAL(KIND=dp),DIMENSION(1:nvol),INTENT(IN) :: vol_SH,vol_NH

! ... local
      integer :: ivol,i

      ivol = INT(ctime/dtvol) + 1

!-----------------------------------------------------------------------
!     ice volume in the Southern Hemisphere, vol_SH (m^3)
!-----------------------------------------------------------------------

      OPEN(1,FILE='bism_data/vol_SH.dat',STATUS='UNKNOWN')
      WRITE(1,*) ivol
      do i=1,ivol
        WRITE(1,*) dtvol*DBLE(i-1),vol_SH(i)
      enddo
      CLOSE(1)

!-----------------------------------------------------------------------
!     ice volume in the Northern Hemispere, vol_NH (m^3)
!-----------------------------------------------------------------------

      OPEN(1,FILE='bism_data/vol_NH.dat',STATUS='UNKNOWN')
      WRITE(1,*) ivol
      do i=1,ivol
        WRITE(1,*) dtvol*DBLE(i-1),vol_NH(i)
      enddo
      CLOSE(1)

!=======================================================================
      end subroutine cidm_vol_writ
!=======================================================================

!=======================================================================
!     This subroutine read ice volume.

!     vol_SH: total ice volume in the Southern Hemisphere
!     vol_NH: total ice volume in the Northern Hemisphere

!     based on code by: M. Yoshimori
!=======================================================================

      subroutine cidm_vol_read(vol_SH,vol_NH)

      USE global_param   ! dp,nvol,ivol,istart,itime
      implicit none

      REAL(KIND=dp),DIMENSION(1:nvol),INTENT(OUT) :: vol_SH,vol_NH

! ... Local variables
      integer :: ivol,i

      OPEN(1,FILE='bism_data/vol_SH.dat',STATUS='OLD')
      READ(1,*) ivol
      do i=1,ivol
        READ(1,*) ctime,vol_SH(i)
      enddo
      CLOSE(1)

      OPEN(1,FILE='bism_data/vol_NH.dat',STATUS='OLD')
      READ(1,*) ivol
      do i=1,ivol
        READ(1,*) ctime,vol_NH(i)
      enddo
      CLOSE(1)

!=======================================================================
      end subroutine cidm_vol_read
!=======================================================================
