       subroutine cidmout (snapts, timavgts, tsits, timunit
     &,                    expnam, relyr, stamp)
!=======================================================================
!     output routine for energy-moisture balance model
!=======================================================================

      use global_vars

      character(120) :: ftsi, ftavg, fsnap, fname, file_stamp, timunit
      character(120) :: new_file_name
      character(60) :: expnam
      character(32) :: stamp
      save ftsi, ftavg, fsnap
      data ftsi  /' '/
      data ftavg /' '/
      data fsnap /' '/

      integer ntrec
      logical snapts, timavgts, tsits
      real avgper, relyr

      if (timavgts) then

!-----------------------------------------------------------------------
!       write icesheet time averaged data
!-----------------------------------------------------------------------

#if defined uvic_multiple_files
        ntrec = 0
        ftavg = file_stamp ('time_mean_ice',stamp,'.nc')
        ftavg = new_file_name (ftavg)
#else
        ntrec = 1
        if (ftavg .eq. ' ') then
          ntrec = 0
          ftavg = file_stamp ('time_mean_ice',stamp,'.nc')
          ftavg = new_file_name (ftavg)
        endif
#endif
        avgper = delt
        is = 1
        ie = nlon
        js = 1
        je = nlat

        call cidm_snap_out (ftavg, is, ie, js, je, nlon, nlat, lon, lat
     &,                     ntrec, timunit, expnam, avgper, relyr, stamp
     &,                     hg(is:ie,js:je), hice(is:ie,js:je)
     &,                     hi(is:ie,js:je), balance(is:ie,js:je)
     &,                     tlat(is:ie,js:je), tlon(is:ie,js:je)
     &,                     ulat(is:ie,js:je), ulon(is:ie,js:je)
     &                      )

        write (*,'(a,i4,a,a,a,i10,a,a)') '=> Icesheet time mean #'
     &,   ntrec, ' written to ',trim(fsnap),' on ts = ',itt, ', ', stamp

      endif

      if (snapts) then

!-----------------------------------------------------------------------
!       write icesheet snapshot
!-----------------------------------------------------------------------

#if defined uvic_multiple_files
        ntrec = 0
        fsnap = file_stamp ('snapshots_ice',stamp,'.nc')
        fsnap = new_file_name(fsnap)
#else
        ntrec = 1
        if (fsnap .eq. ' ') then
          ntrec = 0
          fsnap = file_stamp ('snapshots_ice',stamp,'.nc')
          fsnap = new_file_name(fsnap)
        endif
#endif
        avgper = 0.
        is = 1
        ie = nlon
        js = 1
        je = nlat

        call cidm_snap_out (fsnap, is, ie, js, je, nlon, nlat, lon, lat
     &,                     ntrec, timunit, expnam, avgper, relyr, stamp
     &,                     hg(is:ie,js:je), hice(is:ie,js:je)
     &,                     hi(is:ie,js:je), balance(is:ie,js:je)
     &,                     tlat(is:ie,js:je), tlon(is:ie,js:je)
     &,                     ulat(is:ie,js:je), ulon(is:ie,js:je)
     &                      )

        write (*,'(a,i4,a,a,a,i10,a,a)') '=> Icesheet snapshot #'
     &,   ntrec, ' written to ',trim(fsnap),' on ts = ',itt, ', ', stamp

      endif

      return
      end

      subroutine cidm_snap_writ(sum_calv)
      return
      end
