!****************************************************************************
! Assign temperatures to cell interfaces for the velocity integration.
! This version bases interface assignment on upstream direction.
! Incorporate correction for the pressure-softening de facto here
! (the flow law has no pressure effects in it).

  subroutine interface_temps(ticev,tt,tp,hi,Hice)

!****************************************************************************
    USE global_param
    implicit none
    REAL(dp), INTENT(IN), DIMENSION(nvertp,nlonp,nlatp) :: ticev
    REAL(dp), INTENT(IN), DIMENSION(nlon,nlat) :: Hice,hi
    REAL(dp), INTENT(OUT), DIMENSION(nvert,nlonp,nlat-1) :: tt
    REAL(dp), INTENT(OUT), DIMENSION(nvert,nlon-1,nlatp) :: tp

    ! Local
    integer :: i,j,k,im,ip,jm,jp
    REAL(dp) :: hcrit,tmcorr,Hlt,Hlo
    REAL(dp), DIMENSION(nvertp,nlon,nlat) :: temp
    REAL(dp), DIMENSION(nvertp) :: logzeta

    hcrit = 10._dp                         ! Threshold for dynamic influence
    do k=1,nvertp
      logzeta(k) = LOG(zeta(k))/aa
    enddo

    do j=2,nlat-1
      do i=2,nlon-1
        im = i-1
        jm = j-1
        temp(1:nvertp,i,j) = ticev(1:nvertp,im,jm)
      enddo
    enddo

    do j = 1,nlat
      temp(1:nvertp,1,j)    = temp(1:nvertp,nlon-1,j)
      temp(1:nvertp,nlon,j) = temp(1:nvertp,2,j)
    enddo

    do i = 1,nlon
      temp(1:nvertp,i,1)    = temp(1:nvertp,i,2)
      temp(1:nvertp,i,nlat) = temp(1:nvertp,i,nlat-1)
    enddo

!****************************************************************************
    ! Assign lower and left interfaces
    do j=2,nlatp
      do i=1,nlon-1
        ip = i+1
        jp = j+1

        Hlt = r2*(Hice(ip,jp) + Hice(i,jp))
        Hlo = r2*(Hice(ip,jp) + Hice(ip,j))

!*******************************************************************
!*******************************************************************
        if (Hice(ip,jp) < zerop) then        !! No ice here
                                        !! Assign upstream or null T

          if (Hlt < zerop) then           ! No zonal flux
            do k=1,nvert
              tp(k,i,j) = tnoice
            enddo
          else                                   ! Default Eward
            do k=1,nvert
              tmcorr = fptdep*Hlt*r2*(logzeta(k)+logzeta(k+1))
              tp(k,i,j) = MIN(r2*(temp(k,i,j) + temp(k+1,i,j)) &
                                                     + tmcorr, triplept)
            enddo
          endif

        else                                !! Ice present; look for upstream

          if (i == nlonp) then           ! Default Eward
            do k=1,nvert
              tmcorr = fptdep*Hlt*r2*(logzeta(k)+logzeta(k+1))
              tp(k,i,j) = MIN(r2*(temp(k,i,j) + temp(k+1,i,j)) &
                                                     + tmcorr, triplept)
            enddo

          else                                  ! Interior
            if (hi(ip,jp) < hi(i,jp)) then           ! Eastward flow
              do k=1,nvert
                tmcorr = fptdep*Hlt*r2*(logzeta(k)+logzeta(k+1))
                tp(k,i,j) = MIN(r2*(temp(k,i,j) + temp(k+1,i,j)) &
                                                    + tmcorr, triplept)
              enddo
            elseif (hi(ip,jp) > hi(i,jp)) then      ! Westward flow
              do k=1,nvert
                tmcorr = fptdep*Hlt*r2*(logzeta(k)+logzeta(k+1))
                tp(k,i,j) = MIN(r2*(temp(k,ip,j) + temp(k+1,ip,j)) &
                                                    + tmcorr, triplept)
              enddo
            else                                   ! No flow
                 do k=1,nvert
                tmcorr = fptdep*Hlt*r2*(logzeta(k)+logzeta(k+1))
                tp(k,i,j) = MIN(p25*(temp(k,ip,j) + temp(k+1,ip,j) &
                                + temp(k,i,j) + temp(k+1,i,j)) &
                                                       + tmcorr, triplept)
              enddo
            endif
          endif          ! Boundary block
        endif                ! If ice block

!*******************************************************************
!*******************************************************************
        ! Meridional interface temperatures

        if (Hice(ip,jp) < zerop) then        !! No ice here
                                        !! Assign upstream or null T

          if (Hlo < zerop) then           ! No meridional flux
            do k=1,nvert
              tt(k,i,j) = tnoice
            enddo
          else                                   ! Default Northward
            do k=1,nvert
              tmcorr = fptdep*Hlo*r2*(logzeta(k)+logzeta(k+1))
              tt(k,i,j) = MIN(r2*(temp(k,i,j)+temp(k+1,i,j)) &
                                                  + tmcorr, triplept)
            enddo
          endif

        else                                !! Ice present; look for upstream

          if (j == nlatp) then           ! Default Northward
            do k=1,nvert
              tmcorr = fptdep*Hlo*r2*(logzeta(k)+logzeta(k+1))
              tt(k,i,j) = MIN(r2*(temp(k,i,j)+temp(k+1,i,j)) &
                                                  + tmcorr, triplept)
            enddo

          else                                  ! Interior
            if (hi(ip,jp) > hi(ip,j)) then                ! Southward flow
              do k=1,nvert
                tmcorr = fptdep*Hlo*r2*(logzeta(k)+logzeta(k+1))
                tt(k,i,j) = MIN(r2*(temp(k,i,jp) + temp(k+1,i,jp)) &
                                                    + tmcorr, triplept)
              enddo
            elseif (hi(ip,jp) < hi(ip,j)) then                ! Northward flow
              do k=1,nvert
                tmcorr = fptdep*Hlo*r2*(logzeta(k)+logzeta(k+1))
                tt(k,i,j) = MIN(r2*(temp(k,i,j)+temp(k+1,i,j)) &
                                                    + tmcorr, triplept)
              enddo
            else
              do k=1,nvert                                ! No flow
                tmcorr = fptdep*Hlo*r2*(logzeta(k)+logzeta(k+1))
                tt(k,i,j) = MIN(p25*(temp(k,i,jp)+temp(k+1,i,jp) &
                                     + temp(k,i,j)+temp(k+1,i,j)) &
                                                   + tmcorr, triplept)
              enddo
            endif
          endif          ! Boundary block
        endif                ! If ice block

      enddo
    enddo

!****************************************************************************
  end subroutine interface_temps
!****************************************************************************
