!=======================================================================
!     Glen's flow law parameters as a function of temperature
!=======================================================================

      FUNCTION B(T) RESULT(res)

#if defined ubc_cidm
      USE global_param   ! dp,itdcoup,Rgas
                         ! Boiso,Bocold,Bowarm,Qactiso,Qactwarm,Qactcold
      implicit none

      REAL(kind=dp),INTENT(IN) :: T
      REAL(kind=dp) :: res

!      if (itdcoup == 0) then
!        res = Boiso*EXP(-Qactiso/(Rgas*T))
!      elseif (itdcoup == 1) then
        if (T < 263.15_dp) then
          res = Bocold*EXP(-Qactcold/(Rgas*T))
        else
          res = Bowarm*EXP(-Qactwarm/(Rgas*T))
        endif
!      endif

#endif
!=======================================================================
      end FUNCTION B
!=======================================================================
