!=======================================================================
!   Allocate array dimensions based on runtime model options and
!   problem size.  Arrays are declared allocatable in module global_vars.
!   Model options are also declared here and are read in from
!   script file bonhomme_opt.

!   based on code by: M. Yoshimori
!=======================================================================

      subroutine is_arrays

      USE global_vars
      USE icetd_arrays
      USE subgrid_arrays
#if !defined uvic_embm
  USE deg_day_vars
#endif
      USE cidm_mod_mass
      USE hydrol_arrays
      USE geol_arrays
      USE bedtd_arrays
      USE shelf_arrays
      implicit none

  integer :: error

  ! Define workspace for arrays
  nlonp = nlon-2          ! Physical (as opposed to numerical) grid size
  nlatp = nlat-2
  nvertp = nvert+1
  njac1 = 2*nlatp                 ! Jacobian matrix dimensions
  njac2 = 2*nlonp
  nwsys = nlon*nlat              ! Sheet water system unknowns
  njw = nlon*nlat                ! Vector of sheet water unknowns
  njacw = nwsys*ndepw + 2       ! Sparse matrix dimension, water eqns
  ndsys = nlon*nlat                  ! Vector of ice thicknesses
  njacd = ndsys*ndepd + 2         ! Sparse matrix dimension, dynamical eqns
  ntsys = nvert + nvertb
  ntfrz = nvert + nxibf

!***************************************************************************
  ! Miscellaneous: flags, etc.
#if !defined uvic_embm
  ALLOCATE (ideep(nlon,nlat))          ; ideep = 0      ! Deep ocean map  (1/0)
  ALLOCATE (igreen(nlon,nlat))          ; igreen = 0     ! Greenland mask  (1/0)
  ALLOCATE (iglacial(nlon,nlat))  ; iglacial = 0   ! Glacial/terr. ice (1/0)
#endif
  ALLOCATE (imargin(nlon,nlat))          ; imargin = 0    ! Marginal cell? (1/0)
  ALLOCATE (ifloating(nlon,nlat)) ; ifloating = 0  ! Floating ice here? (1/0)
#if !defined uvic_embm
  ALLOCATE (icelevel(nlon,nlat))  ; icelevel = 1   ! Subgrid level  (1-nhyps)
#endif
  ALLOCATE (icover(nlon,nlat))           ; icover = 0     ! Ice coverage here? (1/0)

!-----------------------------------------------------------------------
!     mask
!-----------------------------------------------------------------------

      ALLOCATE (iland(nlon,nlat))  ; iland = 0     ! Land/ocean map  (1/0)
      ALLOCATE (idomain(nlon,nlat)); idomain = 0   ! domain map (-1/0/1)
#if !defined uvic_embm
      ALLOCATE (icemask(nlon,nlat)); icemask = 0  ! ice map  (1/0)
#endif

!-----------------------------------------------------------------------
!     geometry
!-----------------------------------------------------------------------

      ALLOCATE (lon(1:nlon)); lon = c0   ! longitude (degree)
      ALLOCATE (lat(1:nlat)); lat = c0   ! latitude  (degree)
      ALLOCATE (area(nlat)); area = c0   ! True cell area (m^2)
      ALLOCATE (delx(nlat)); delx = c0         ! Zonal cell dimension (m)
      ALLOCATE (delxhi(0:nlat)); delxhi = c0   ! Interface dimension (m)
      ALLOCATE (clat(nlat)); clat = c0         ! colatitudes
      ALLOCATE (clathi(0:nlat)); clathi = c0   ! interface colatitudes
      ALLOCATE (sine(nlat)); sine = c0         ! sine of colatitude
      ALLOCATE (sinehi(0:nlat)); sinehi = c0   ! sine of interface colat
      ALLOCATE (Bjvect(nlat)); Bjvect = c1     ! grid term
      ALLOCATE (Cjvect(nlat)); Cjvect = c1     ! grid term
#if !defined uvic_embm
      ALLOCATE (latitude(nlon,nlat)); latitude = c0   ! Cell latitude (deg)
#endif

!-----------------------------------------------------------------------
!     allocate arrays for mass balance
!-----------------------------------------------------------------------

      if (imass == 1) then
        ALLOCATE (s_ann(1:nlon,1:nlat)); s_ann = c0
        ALLOCATE (m_ann(1:nlon,1:nlat)); m_ann = c0
# if defined ubc_cidm_refreeze
        ALLOCATE (r_ann(1:nlon,1:nlat)); r_ann = c0
# endif
      elseif (imass == 2) then
        ALLOCATE (p_mon(1:nlon,1:nlat,1:nmonth)); p_mon = c0
        ALLOCATE (t_mon(1:nlon,1:nlat,1:nmonth)); t_mon = c0
      elseif (imass == 3) then
        ALLOCATE (p_ann(1:nlon,1:nlat)); p_ann = c0
        ALLOCATE (t_ann(1:nlon,1:nlat)); t_ann = c0
      endif

      ALLOCATE (acc(1:nlon,1:nlat))    ; acc=c0
      ALLOCATE (smelt(1:nlon,1:nlat))  ; smelt=c0
      ALLOCATE (calve(1:nlon,1:nlat))  ; calve=c0
      ALLOCATE (balance(1:nlon,1:nlat)); balance=c0

!-----------------------------------------------------------------------
!     allocate arrays for ice volume
!-----------------------------------------------------------------------

      ALLOCATE (vol_SH(1:nvol)) ; vol_SH = c0
      ALLOCATE (vol_NH(1:nvol)) ; vol_NH = c0

#if !defined uvic_embm
  ! Mass balance
  ALLOCATE (precip(nlon,nlat))          ; precip=c0       ! Ice-equiv. precip (m/a)
  ALLOCATE (rainfall(nlon,nlat))  ; rainfall=c0     ! Water-equiv. rain (m/a)
  ALLOCATE (tair(nlon,nlat))           ; tair=c0         ! Air temperature (K)
  ALLOCATE (pddnet(nlon,nlat))    ; pddnet=c0       ! Annual PDD (\degC d)
  ALLOCATE (annamp(nlon,nlat))          ; annamp=c0       ! Annual temp. cycle (K)
  ALLOCATE (geo(nlon,nlat))           ; geo=c0          ! Geoth. heat flux (W/m^2)
  ALLOCATE (tsea(nlon,nlat))          ; tsea=c0         ! SST (K)
  ALLOCATE (tseaC(nlon,nlat))           ; tseaC=c0        ! SST (deg C)

  ALLOCATE (glacial(0:ncore))           ; glacial=c0            ! Glacial index
  ALLOCATE (pfrac(0:ncore))           ; pfrac=c0            ! Wisc. precip fraction
  ALLOCATE (delO(0:ncore))           ; delO=c0         ! GRIP del-18 record
  ALLOCATE (delsea(0:ncore))           ; delsea=c0       ! Sea-level history

  if ((imass>=5).and.(imass<=8)) then   ! Deg-day method or monthly data
    ALLOCATE (pdd(nmonth,nlon,nlat))                 ; pdd = c0
    ALLOCATE (pdata(nmonth,nlon,nlat))                 ; pdata = c0
    ALLOCATE (tdata(nmonth,nlon,nlat))                 ; tdata = c0
    ALLOCATE (tsummer(nlon,nlat))                  ; tsummer = c0
    ALLOCATE (ftable(0:npddamp,0:ntable))        ; ftable = c0
    ALLOCATE (pddtable(0:npddamp,0:ntable))        ; pddtable = c0
  endif

  if (ialbedo==1) then                    ! Susan  Marshall albedo code
    ALLOCATE (snow(nmonth,nlon,nlat))                 ; snow = c0
    ALLOCATE (albedo(nmonth,nlon,nlat))         ; albedo = c0
    ALLOCATE (coszrs(nlon,nlat))                ; coszrs = c0
    ALLOCATE (bckgrnd(nlon,nlat))                ; bckgrnd = c0
    ALLOCATE (snowdep(nlon,nlat))                ; snowdep = c0
    ALLOCATE (snowage(nlon,nlat))                ; snowage = c0
    ALLOCATE (snowfrac(nlon,nlat))                 ; snowfrac = c0
    ALLOCATE (soot(nlon,nlat))                         ; soot = c0
    ALLOCATE (snowrad(nlon,nlat))                 ; snowrad = c0
  endif

  if ((iclim>=6).and.(iclim<=10)) then
    ALLOCATE (tair0(nlon,nlat))                        ; tair0 = c0
    ALLOCATE (tsea0(nlon,nlat))                        ; tsea0 = c0
    ALLOCATE (tsea21(nlon,nlat))                ; tsea21 = c0
    ALLOCATE (p0(nmonth,nlon,nlat))                 ; p0 = c0
    ALLOCATE (p21(nmonth,nlon,nlat))                ; p21 = c0
    ALLOCATE (ppres(nmonth,nlon,nlat))                ; ppres = c0
    ALLOCATE (t0(nmonth,nlon,nlat))                    ; t0 = c0
    ALLOCATE (t21(nmonth,nlon,nlat))                   ; t21 = c0
  endif
#endif

!*********************************************************************************
  !! Ice thermomechanics

  ! Ice thickness and topography fields
  ALLOCATE (slope(nlon,nlat))           ; slope = c0     ! Ice sheet surface slope
#if !defined uvic_embm
  ALLOCATE (slope0(nlon,nlat))           ; slope0 = c0    ! Initial surface slope
  ALLOCATE (hi0(nlon,nlat))          ; hi0 = c0       ! Initial ice sheet surface  (m)
#endif
  ALLOCATE (Hocean(nlon,nlat))           ; Hocean = c0    ! Ocean depth (m)
  ALLOCATE (hg(nlon,nlat))           ; hg = c0        ! Bed topography (m)
  ALLOCATE (hgk(nlon,nlat))           ; hgk = c0       ! Previous bed topography (m)
  ALLOCATE (hgkt(nlon,nlat))          ; hgkt = c0      ! T-loop, prev. bed topo. (m)
  ALLOCATE (dhgdt(nlon,nlat))          ; dhgdt = c0     ! Isostatic adjustment rate (m/a)
  ALLOCATE (hg0(nlon,nlat))           ; hg0 = c0       ! Initial bed topography (m)
  ALLOCATE (hi(nlon,nlat))          ; hi = c0        ! Ice sheet surface  (m)
  ALLOCATE (hik(nlon,nlat))           ; hik = c0       ! Prev. ice surface (m)
  ALLOCATE (hikt(nlon,nlat))          ; hikt = c0      ! T-loop, prev ice surface (m)
  ALLOCATE (Hice(nlon,nlat))           ; Hice = c0      ! Ice sheet thickness (m)
  ALLOCATE (Hicek(nlon,nlat))           ; Hicek = c0     ! Prev. ice sheet thickness (m)
  ALLOCATE (Hicekt(nlon,nlat))    ; Hicekt = c0    ! T-loop prev. ice thickness (m)

  if (irebound < 2)  ntisos = 0          ! Local earth visco-elastic response
  ALLOCATE (vert(0:200,0:ntisos+1))                ; vert = c0
  ALLOCATE (load(0:ntisos,nlon,nlat))                ; load = c0
  ALLOCATE (loadscale(nlat))                        ; loadscale = c1
  ALLOCATE (hg_maxwell(0:2,nlon,nlat))                ; hg_maxwell = c0
  ALLOCATE (time_maxwell(0:2))                        ; time_maxwell = c0
  ALLOCATE (alinear(nlon,nlat))                        ; alinear = c0
  ALLOCATE (aquad(nlon,nlat))                        ; aquad = c0
  ALLOCATE (bquad(nlon,nlat))                        ; bquad = c0
  ALLOCATE (curvature(nlon,nlat))                ; curvature = c0

!************************
  !! Velocity fields

  ! Fluxes
  ALLOCATE (Bbar(nlon,nlat))       ; Bbar = c0       ! Column stiffness (Pa^-3 a^-1)
  ALLOCATE (Tbar(nlon,nlat))            ; Tbar = 270._dp  ! Column average temp. (K)
  ALLOCATE (ftsht(nlonp,nlat-1))   ; ftsht = c0
  ALLOCATE (fpsht(nlon-1,nlatp))   ; fpsht = c0
  ALLOCATE (ftshtk(nlonp,nlat-1))  ; ftshtk = c0
  ALLOCATE (fpshtk(nlon-1,nlatp))  ; fpshtk = c0
  ALLOCATE (vb(nlonp,nlat-1))             ; vb = c0
  ALLOCATE (ub(nlon-1,nlatp))      ; ub = c0
  ALLOCATE (vbk(nlonp,nlat-1))     ; vbk = c0
  ALLOCATE (ubk(nlon-1,nlatp))     ; ubk = c0
  ALLOCATE (ivb(nlonp,nlat-1))     ; ivb = 0
  ALLOCATE (iub(nlon-1,nlatp))     ; iub = 0

  ! Horizontal fields
  ALLOCATE (vt(nvertp,nlonp,nlat-1))   ; vt = c0     ! Merid. sheet velocity (m/a)
  ALLOCATE (vp(nvertp,nlon-1,nlatp))   ; vp = c0     ! Zonal sheet velocity (m/a)
  ALLOCATE (wvel(nvertp,nlonp,nlatp))  ; wvel = c0   ! Vert. vel. (m/a)

!***************************
  ! Temperature fields
  if (itherm > 0) then                        ! Solve temperatures
    ALLOCATE (tice(nvertp,nlonp,nlatp))    ; tice = tnoice
    ALLOCATE (ticek(nvertp,nlonp,nlatp))   ; ticek = tnoice
    ALLOCATE (ticev(nvertp,nlonp,nlatp))   ; ticev = tnoice
    ALLOCATE (tcolij(nvertp))                    ; tcolij = tnoice
    ALLOCATE (tcolijk(nvertp))             ; tcolijk = tnoice
    ALLOCATE (ttt(2:nvertp,nlonp,nlat-1))  ; ttt = tnoice
    ALLOCATE (tpt(2:nvertp,nlon-1,nlatp))  ; tpt = tnoice
    ALLOCATE (vtt(nvertp,nlonp,nlat-1))    ; vtt = c0
    ALLOCATE (vpt(nvertp,nlon-1,nlatp))    ; vpt = c0
    ALLOCATE (wvelt(nvertp,nlonp,nlatp))   ; wvelt = c0

    if (itdcoup == 1) then                ! Thermally-coupled flow
      ALLOCATE (Btable(0:nglen_table))     ; Btable = c0
      ALLOCATE (tt(nvert,nlonp,nlat-1))    ; tt = tnoice
      ALLOCATE (tp(nvert,nlon-1,nlatp))    ; tp = tnoice
    endif
  endif

!***************************
  ! Ice shelf fields
  ALLOCATE (ifloatrt(nlon-1,nlatp))        ; ifloatrt = 0
  ALLOCATE (ifloathi(nlonp,nlat-1))        ; ifloathi = 0
  if (ishelf > 2) then                        ! Solve ice shelf velocities
    ALLOCATE (ioutlet(nlon,nlat))            ; ioutlet = 0
    ALLOCATE (nfront(nlon,nlat))             ; nfront = 0
    ALLOCATE (icefront(nface,nlon,nlat))     ; icefront = 0
    ALLOCATE (strinv(nlon,nlat))             ; strinv = c0
    ALLOCATE (taubed(ncoord,nlon,nlat))      ; taubed = c0
    ALLOCATE (taumar(ncoord,nlon,nlat))      ; taumar = c0
  endif

!***************************************************************************
  ! Hydrological variables
  ALLOCATE (bmelt(nlon,nlat))                ; bmelt = c0      ! Basal melt rate (m/a)
#if !defined uvic_embm
  ALLOCATE (peff(nlon,nlat))           ; peff = c0       ! Eff. water pressure (Pa)
  ALLOCATE (pwater(nlon,nlat))         ; pwater = c0     ! Water pressure (Pa)
#endif
  ALLOCATE (pice(nlon,nlat))           ; pice = c0       ! Ice pressure (Pa)
#if !defined uvic_embm
  ALLOCATE (pnorm(nlon,nlat))          ; pnorm = c0      ! Norm. water pressure (Pa)
  ALLOCATE (bwater(nlon,nlat))         ; bwater = c0     ! Basal water thickness (m)
#endif

  if (igingembre > 0) then
    ALLOCATE (ilake(nlon,nlat))               ; ilake = 0      ! Proglacial lake map  (1/0)
    ALLOCATE (iriver(nlon,nlat))       ; iriver = 0     ! River outlet map (1/0)
    ALLOCATE (swater(nlon,nlat))       ; swater = c0
    ALLOCATE (moulin(nlon,nlat))       ; moulin = c0
    ALLOCATE (river(nlon,nlat))        ; river = c0
    ALLOCATE (wyflux(nlonp,nlat-1))    ; wyflux = c0
    ALLOCATE (wxflux(nlon-1,nlatp))    ; wxflux = c0
    ALLOCATE (water(nwsys))               ; water = c0
    ALLOCATE (waterk(nwsys))               ; waterk = c0
    ALLOCATE (dhwdt(nwsys))            ; dhwdt = c0
    ALLOCATE (resw(nwsys))               ; resw = c0
    ALLOCATE (delw(nwsys))               ; delw = c0
    ALLOCATE (jacw(njacw))               ; jacw = c0
    ALLOCATE (ijacw(njacw))            ; ijacw = 0
  endif

!***************************************************************************
  ! Bed thermal model variables

  ALLOCATE (tsole(nlon,nlat))          ; tsole=c0       ! Basal ice temperature (K)
  if (ibedtd > 0) then
    ALLOCATE (tbed(nvertb,nlon,nlat))  ; tbed = 300.    ! Bed temperatures (K)
    ALLOCATE (pfrost(nlon,nlat))       ; pfrost = c0    ! Frozen layer thickness (m)
    ALLOCATE (hgf(nlon,nlat))          ; hgf = c0       ! Frozen layer elevation (m)
    ALLOCATE (hgfk(nlon,nlat))         ; hgfk = c0      ! Previous frozen layer (m)
    ALLOCATE (tbedij(nvertb+1))        ; tbedij = c0    ! Local bed temperature (K)
    ALLOCATE (tbedijk(nvertb+1))       ; tbedijk = c0   ! Prev. bed temperatures K)
    ALLOCATE (resb(nvertb))            ; resb = c0      ! Resid., bed TD balance (K)
    ALLOCATE (ibmode(nlon,nlat))       ; ibmode = 0     ! Frozen/unfrozen mask (2/1)
    ALLOCATE (tdiffe(nlon,nlat))       ; tdiffe = c0    ! Crust thermal diff. (m^2/s)
    ALLOCATE (htce(nlon,nlat))         ; htce = c0      ! Crust heat cap. (J/kg K)
    ALLOCATE (wgnd(nlon,nlat))         ; wgnd = c0      ! Vert. grndwater flow (m/a)
    ALLOCATE (tconde(nlon,nlat))       ; tconde=c0      ! Crust thermal cond. (W/m K)
    ALLOCATE (pore(nlon,nlat))                ; pore=c0        ! Crust porosity (bed TD)

    ALLOCATE (coifull(ntsys,ntsys))    ; coifull = c0
    ALLOCATE (coefull(ntsys,ntsys))    ; coefull = c0
    ALLOCATE (coconfull(ntsys))        ; coconfull = c0
    ALLOCATE (tfullij(ntsys))          ; tfullij = c0
    ALLOCATE (tfullijk(ntsys))         ; tfullijk = c0
    ALLOCATE (restfull(ntsys))         ; restfull = c0
    ALLOCATE (dtdtfull(ntsys))         ; dtdtfull = c0
  endif

!***************************************************************************
  ! Geologic variables
  if (itrack == 1) then
    ALLOCATE (vtk(nvertp,nlonp,nlat-1)) ; vtk=c0        ! Previous vel fields
    ALLOCATE (vpk(nvertp,nlon-1,nlatp)) ; vpk=c0
    ALLOCATE (ducks(nducks,ntrack))     ; ducks=c0      ! Subglacial particles
    ALLOCATE (gouge(nlon,nlat,nbin))    ; gouge=c0      ! Striation depths
    ALLOCATE (erode(nlon,nlat))         ; erode=c0      ! Bedrock erodability
  endif

  if (isilt == 1) then
    ALLOCATE (silt(nsilt,nlon,nlat))    ; silt = c0     ! Basal debris layer (m)
    ALLOCATE (siltk(nsilt,nlon,nlat))   ; siltk = c0    ! Prev debris layer (m)
    ALLOCATE (depos(nsilt,nlon,nlat))   ; depos = c0    ! Subice debris layer (m)
    ALLOCATE (deposk(nsilt,nlon,nlat))  ; deposk = c0   ! Prev. debris layer (m)
    ALLOCATE (siltvol(nlon,nlat))       ; siltvol = c0  ! Net basal debris (m)
    ALLOCATE (cover(nsilt,nlon,nlat))   ; cover = c0    ! Bedrock/surface area
    ALLOCATE (entrate(nsilt))           ; entrate = c0  ! Unit entrainment rate (m/a)
    ALLOCATE (fallout(nsilt))           ; fallout = c0  ! Unit fallout rate (a^-1)
  endif

!***************************************************************************
  ! Cell attributes
#if !defined uvic_embm
  ALLOCATE (landfrac(nlon,nlat))             ; landfrac = c0    ! Fraction of subgrid land
#endif

  if ((isurf > 0).or.(isilt == 1)) then
    ALLOCATE (isfgeol(nlon,nlat,nsurf)) ; isfgeol = 0      ! Surficial map
    ALLOCATE (sedtype(nlon,nlat,nsedtype)) ; sedtype = c0  ! Sediment type
    ALLOCATE (hconds(nlon,nlat))         ; hconds = c0      ! Hyd. cond. (m/a)
    ALLOCATE (seddep(nlon,nlat))        ; seddep = c0      ! thickness (m)
    ALLOCATE (sedpor(nlon,nlat))         ; sedpor = c0      ! porosity
    ALLOCATE (storage(nlon,nlat))         ; storage = c0     ! storage (m)
  endif
  if ((ibedr > 0).or.(isilt == 1)) then
    ALLOCATE (ibgeol(nlon,nlat,nbedr))  ; ibedr = 0         ! Bedrock map
  endif

  if (isubtop > 0) then             ! Subgrid attributes
    ALLOCATE (rough(nlon,nlat))         ; rough = c0       ! Topo. roughness (Log)
    ALLOCATE (bedcoup(nlon,nlat))              ; bedcoup = c0           ! Bed coupling coefficient
    ALLOCATE (hmin(nlon,nlat))                 ; hmin = c0           ! Minimum cell height (m)
    ALLOCATE (hmax(nlon,nlat))                ; hmax = c0           ! Maximum cell height (m)
    ALLOCATE (hmean(nlon,nlat))                ; hmean = c0           ! Mean cell elevation (m)
    ALLOCATE (range(nlon,nlat))                ; range = c0           ! Cell elevation range (m)
    ALLOCATE (hypso(nlon,nlat))                ; hypso = c0           ! Cell hypsometry
    if ((isubtop==2).or.(isubtop==3)) then       ! Subgrid mass balance
      ALLOCATE (Heff(nlon,nlat))          ; Heff = c0
      ALLOCATE (wtsub(nhyps,nlon,nlat))   ; wtsub = c0
      ALLOCATE (hsub(nhyps,nlon,nlat))    ; hsub = c0
      ALLOCATE (icesub(nhyps,nlon,nlat))  ; icesub = c0
      ALLOCATE (meltsub(nhyps,nlon,nlat)) ; meltsub = c0
      ALLOCATE (accsub(nhyps,nlon,nlat))  ; accsub = c0
      ALLOCATE (balsub(nhyps,nlon,nlat))  ; balsub = c0
      ALLOCATE (pddsub(nhyps,nlon,nlat), STAT=error) ; pddsub = c0
      if (error /= 0) then
        WRITE(45,*) 'Unallocatable: requested space unavailable - pddsub'
        STOP
      endif
    endif
  endif

!***************************************************************************
  ! Numerical stuffs
  ALLOCATE (zeta(nvertp))         ; zeta = c0      ! Ice dynamic grid transform
  ALLOCATE (xi(nvertp))                ; xi = c0        ! Ice thermodynamic grid transform
  ALLOCATE (xibc(nxibc))        ; xibc = c0      ! Transformed grid: unfrozen zone
  ALLOCATE (xibf(nxibf))        ; xibf = c0      ! Transformed grid: frozen zone
  ALLOCATE (peclet(nvertp))        ; peclet = c0    ! Grid peclet numbers for column

  ALLOCATE (rest(nvertp))       ; rest = c0      ! Residual energy, ice column (K)
  ALLOCATE (dtdt(nvertp))       ; dtdt = c0      ! Temperature disbalance (K)
  ALLOCATE (coimp(nvertp,nvertp)) ; coimp = c0   ! Implicit coefficients: A
  ALLOCATE (coexp(nvertp,nvertp)) ; coexp = c0   ! Explicit coefficients: B
  ALLOCATE (cocon(nvertp))          ; cocon = c0     ! Constant coefficients: c
                                                 ! For system AT^{m+1} = BT^{m} + c

  if (idyn == 1) then         ! ADI solution to dynamics
    ALLOCATE (rhsc(njac2))        ; rhsc = c0      ! Resid. in Newton iteration (m/a)
    ALLOCATE (dhdt(njac2))        ; dhdt = c0      ! Mass disbalance (m/a)
    ALLOCATE (dhdtb(njac2,njac1)) ; dhdtb = c0     ! Equilibrium mass disbalance (m/a)
    ALLOCATE (jac1(njac1,njac1))  ; jac1 = c0      ! Jacobian matrix, sweep 1
    ALLOCATE (jac2(njac2,njac2))  ; jac2 = c0      ! Jacobian matrix, sweep 2

  elseif (idyn == 2) then    ! 2D conjugate gradient solution
    ALLOCATE (dhidt(ndsys))          ; dhidt = c0     ! Rate of change of ice surface

  endif

!=======================================================================
      end subroutine is_arrays
!=======================================================================
