!=======================================================================
!     Solve the full 2D dynamical system.
!=======================================================================

      subroutine is_dyn (hg,hgk,hi,hik,dhgdt,Hice,Hicek,wvel,vt,vp,tiso,&
                                ub,vb,ubk,vbk,iub,ivb,Bbar,Tbar,Hocean,balance,&
                         bmelt,acc,smelt,calve,dhidt,fpshtk,ftshtk,fpsht,&
                         ftsht,pice,icover,iland,ifloating,&
                         ltdcur,ldiverge,res,time,fwater)

!-----------------------------------------------------------------------
!     declare constants and variables
!-----------------------------------------------------------------------

      USE hydrol_arrays
      USE shelf_arrays
      implicit none
      INTEGER, INTENT(IN) :: time
      INTEGER, INTENT(IN), DIMENSION(nlon,nlat) :: iland
      INTEGER, INTENT(INOUT), DIMENSION(nlon,nlat) :: ifloating,icover
      INTEGER, INTENT(INOUT), DIMENSION(nlon-1,nlatp) :: iub
      INTEGER, INTENT(INOUT), DIMENSION(nlonp,nlat-1) :: ivb

      REAL(dp), INTENT(IN) :: tiso
      REAL(dp), INTENT(IN), DIMENSION(nlon,nlat) :: hg,hgk,dhgdt,hik,Hicek,&
                                                    Hocean,bmelt,Tbar,acc,&
                                                    balance,calve,pice
      REAL(dp), INTENT(OUT) :: res
      REAL(dp), INTENT(INOUT), DIMENSION(ndsys) :: dhidt
      REAL(dp), INTENT(INOUT), DIMENSION(nlon,nlat) :: hi,Hice,smelt,Bbar
#if defined uvic_embm
      REAL(dp), INTENT(OUT), DIMENSION(nlon,nlat) :: fwater
#endif
      REAL(dp), INTENT(INOUT), DIMENSION(nlonp,nlat-1) :: vb,vbk,ftshtk,ftsht
      REAL(dp), INTENT(INOUT), DIMENSION(nlon-1,nlatp) :: ub,ubk,fpshtk,fpsht
      REAL(dp), INTENT(INOUT), DIMENSION(nvertp,nlonp,nlatp) :: wvel
      REAL(dp), INTENT(INOUT), DIMENSION(nvertp,nlonp,nlat-1) :: vt
      REAL(dp), INTENT(INOUT), DIMENSION(nvertp,nlon-1,nlatp) :: vp

      LOGICAL, INTENT(IN) :: ltdcur
      LOGICAL, INTENT(INOUT) :: ldiverge

      ! Local variables
      integer :: i,j,ij,jj,ip,jp,k,iter,ntries,iterb,itmax,itol,ncc
      REAL(dp) :: crit,tol,err,fluxin,icein,elfloat
#if defined uvic_embm
      REAL(dp) :: dM_dramuda,dM_dtheta
#endif
      REAL(dp), parameter :: Bslid = -0.001_dp*rhoi*grav
      REAL(dp), parameter :: Dcoeff = c2*(rhoi*grav/erad)**3

      INTEGER, ALLOCATABLE, DIMENSION(:) :: &
                 ijacd          ! Index matrix for jacd (dynamics iteration)

      REAL(dp), ALLOCATABLE, DIMENSION(:) :: &
                 Hvect,&         ! Ice thickness (m)
                 Hvectk,&         ! Previous sheet thickness (m)
                 Hvimp,&         ! Implicit ice thickness vector (m)
                 hivect,&         ! Ice surface (m)
                 hivectk,&         ! Previous ice surface (m)
                 hivimp,&         ! Implicit ice surface vector (m)
                  resd,&                 ! Residuals in dynamical iteration (m/a)
                  deld,&                 ! Step size, Newton iteration (m/a)
                   jacd                   ! Sparse matrix for dynamics iteration

      REAL(dp), DIMENSION(nlonp,nlat-1) :: scalehi,Hhi,hgthi,hgphi,&
                                           gradhi,alphahi,dbarhi
      REAL(dp), DIMENSION(nlon-1,nlatp) :: scalert,Hrt,hgtrt,hgprt,&
                                           gradrt,alphart,dbarrt

!-----------------------------------------------------------------------
!     allocate workspace
!-----------------------------------------------------------------------

      ALLOCATE (Hvect(ndsys))                ; Hvect = c0
      ALLOCATE (Hvectk(ndsys))                ; Hvectk = c0
      ALLOCATE (Hvimp(ndsys))                ; Hvimp = c0
      ALLOCATE (hivect(ndsys))                ; hivect = c0
      ALLOCATE (hivectk(ndsys))                ; hivectk = c0
      ALLOCATE (hivimp(ndsys))                ; hivimp = c0
      ALLOCATE (resd(ndsys))                ; resd = c0
      ALLOCATE (deld(ndsys))                ; deld = c0
      ALLOCATE (jacd(njacd))                ; jacd = c0
      ALLOCATE (ijacd(njacd))                ; ijacd = 0

!-----------------------------------------------------------------------
!     convergence criteria for full system solution
!-----------------------------------------------------------------------

      crit = 1.e-4_dp   ! 0.1 mm/a
      ntries = 41       ! Iteration limit
      res = c1                ! Initialization

!-----------------------------------------------------------------------
!     load current ice thicknesses and surfaces into work vectors
!-----------------------------------------------------------------------

      do j = 1,nlat
        do i = 1,nlon
          k = i+nlon*(j-1)
          Hvectk(k)  = Hice(i,j)
          hivectk(k) = MAX(hi(i,j), sealevel)
        enddo
      enddo

!-----------------------------------------------------------------------
!     initial guesses for update
!-----------------------------------------------------------------------

      deld   = dhidt*delt
      Hvect  = Hvectk + deld
      hivect = hivectk + deld

#if defined uvic_embm
!-----------------------------------------------------------------------
!     set boundary conditions for global domain
!-----------------------------------------------------------------------

      call cidm_lbc_1d(Hvectk)
      call cidm_lbc_1d(hivectk)
      call cidm_lbc_1d(Hvect)
      call cidm_lbc_1d(hivect)

#endif
!-----------------------------------------------------------------------
!     implicit values for Crank-Nicholson (or other) solution
!-----------------------------------------------------------------------

      Hvimp  = fimpd*Hvect + afimpd*Hvectk
      hivimp = fimpd*hivect + afimpd*hivectk

!-----------------------------------------------------------------------
!     calculate ice shelf (floating ice) velocities, based on
!     explicit ice sheet geometry, previous grounded fluxes
!-----------------------------------------------------------------------

      if (ishelf == 3) then
        call shelf(ub,vb,ubk,vbk,hi,Hice,hg,fpshtk,ftshtk,&
                   Bbar,pice,ifloating,time)
      endif

!***********************************************************************
!     Iterate to solution of new ice sheet thicknesses,
!     using an outer Newton iteration and a binconjugate gradient
!     solution to the linearized Jacobian system

      do iter=1,ntries

!-----------------------------------------------------------------------
!       loop over grid from left to right, beginning at lower left
!       calculate residuals and sparse matrix elements
!-----------------------------------------------------------------------

        ncc = ndsys + 1            ! Counter for index in jacd of
                                   ! most recent off-diagonal element
        scalert = c1                   ! Initialize
        scalehi = c1                   ! Initialize

#if !defined uvic_embm
!-----------------------------------------------------------------------
!       call sliding routine for basal velocites
!-----------------------------------------------------------------------

        if (islid > 0) then
          call slidxy(ub,vb,iub,ivb,hi,Hice,Bslid,time)
        endif

#endif
!-----------------------------------------------------------------------
!       calculate ice sheet fluxes at the current iteration
!-----------------------------------------------------------------------

        call is_dyn_eflux(time,ifloating,tiso,Dcoeff,Hvimp,hivimp,ub, &
                          scalert,vp,fpsht,Hrt,hgprt,hgtrt,gradrt,    &
                          alphart,dbarrt)

        call is_dyn_nflux(time,ifloating,tiso,Dcoeff,Hvimp,hivimp,vb, &
                          scalehi,vt,ftsht,Hhi,hgphi,hgthi,gradhi,    &
                          alphahi,dbarhi)

!-----------------------------------------------------------------------
!       volume conservation control on fluxes
!-----------------------------------------------------------------------

!        call flux_control(ub,vb,iub,ivb,Hvimp,balance,bmelt,fpsht,&
!                          ftsht,scalert,scalehi,Hrt,Hhi)

!-----------------------------------------------------------------------
!       calculate rates of change and ice residuals.
!       coad Jacobian matrix.  Nine dependencies for each point.
!-----------------------------------------------------------------------

        call is_dyn_jacob(jacd,ijacd,ub,vb,iub,ivb,fpsht,ftsht,scalert,&
                         Hrt,hgtrt,hgprt,gradrt,alphart,dbarrt,scalehi,&
                         Hhi,hgthi,hgphi,gradhi,alphahi,dbarhi,balance,&
                               bmelt,Bslid,Dcoeff,dhidt,resd,Hvect,Hvectk,&
                         ncc,iland)

        jacd(ndsys+1) = -c1               ! Convention
        ijacd(ndsys+1) = ncc + 1

        call calres(resd,res,ndsys,ndsys)     ! Residual calculation
        if (res < crit) EXIT                        ! Converged acceptably

!-----------------------------------------------------------------------
!       else iterate
!       solve sparse linear system; use biconjugate gradient iteration.
!       pass sparse matrix jacd, ijacd, b=resd, and return x=deld
!-----------------------------------------------------------------------

        itol = 3         ! Routine determines error
        tol = 1.e-6_dp   ! Minimum acceptable residual, m/yr
        itmax = 100      ! Cap on iterations
        call linbcg(jacd,ijacd,njacd,resd,deld,ndsys,ncc,&
                    itol,tol,itmax,err,iterb)

!-----------------------------------------------------------------------
!       update ice thickness with deld (1st-order Talyor expansion)
!-----------------------------------------------------------------------

        Hvect = Hvect + deld
        hivect = hivect + deld

!-----------------------------------------------------------------------
!       negative trap, and adjust surface of floating ice
!-----------------------------------------------------------------------

        do j=1,nlat
          do i=1,nlon
            k = i + nlon*(j-1)
            if (Hvect(k) < c0) then
              Hvect(k) = c0
              hivect(k) = MAX(hg(i,j), sealevel)
            endif
            if ((ishelf >= 1) .and. (ifloating(i,j) == 1)) then
              ! Ice on the shelf (previous time step), adjust surface
              hivect(k) = sealevel + iceberg*Hvect(k)
            endif
           enddo
        enddo

#if defined uvic_embm
!-----------------------------------------------------------------------
!       set boundary conditions for global domain
!-----------------------------------------------------------------------

        call cidm_lbc_1d(Hvect)
        call cidm_lbc_1d(hivect)

#endif
!-----------------------------------------------------------------------
!       implicit values for Crank-Nicholson (or other) solution
!-----------------------------------------------------------------------

        Hvimp = fimpd*Hvect + afimpd*Hvectk
        hivimp = fimpd*hivect + afimpd*hivectk

      enddo
!***********************************************************************

#if defined uvic_embm
!-----------------------------------------------------------------------
!     set boundary conditions for global domain
!-----------------------------------------------------------------------

      call cidm_lbc_1d(Hvect)
      call cidm_lbc_1d(hivect)

#endif
!-----------------------------------------------------------------------
!     write warning message
!-----------------------------------------------------------------------

      if (iter==(ntries+1)) then
        WRITE(*,*) 'Warning, maximum iterations exceeded, dynamics'
        WRITE(*,*) '  time = ', time, ' res = ', REAL(res)
        if (res > 0.1_dp) then
          WRITE(*,*) 'Residual values: '
          do j = 1,nlat
            do i = 1,nlon
              k = i + nlon*(j-1)
              if (resd(k) > 0.1_dp) then
                WRITE(*,*) ' (i,j) = ', i, j, '  res = ', REAL(resd(k))
                WRITE(*,*) ' H = ', REAL(Hvect(k)), &
                           ' h = ', REAL(hivect(k))
              endif
            enddo
          enddo
          if (res > 100._dp) STOP
          ldiverge = .true.
        endif
      endif

!-----------------------------------------------------------------------
!     load updated ice thickness and ice surface altitude into "Hice"
!-----------------------------------------------------------------------

      do j=1,nlat
        do i=1,nlon
          k = i + nlon*(j-1)
          Hice(i,j) = Hvect(k)
        enddo
      enddo

!-----------------------------------------------------------------------
!     get freshwater flux for ocean model
!-----------------------------------------------------------------------

      fwater = c0
      if (ishelf > 0) then   ! floating ice option
        WHERE ((iland == -1).and.(Hice > c0))
          fwater = Hice
          Hice = c0
        endWHERE
      else
        WHERE ((iland ==  0).and.(Hice > c0))
          fwater = Hice
          Hice = c0
        endWHERE
      endif

!-----------------------------------------------------------------------
!     ice surface elevation, hi [m]
!     floating ice or grounded ice over the continental shelf
!-----------------------------------------------------------------------

      call cidm_get_surf(iland,hg,Hice,ifloating,hi)

!-----------------------------------------------------------------------
!     Flag floating ice for next mass balance, dynamics solution
!-----------------------------------------------------------------------

      if (ishelf > 0) then   ! floating ice option
        do j=2,nlatp
          jj = j-1
          do i=2,nlonp
            ij = i-1
            if (ifloating(i,j) == 1) then
              if ((ifloating(i+1,j)==1) .or. (Hice(i+1,j) < zerop)) &
                                                 ifloatrt(i,jj) = 1
              if ((ifloating(i,j+1)==1) .or. (Hice(i,j+1) < zerop)) &
                                                 ifloathi(ij,j) = 1
            endif
          enddo
        enddo
      endif

!-----------------------------------------------------------------------
!     damage control
!-----------------------------------------------------------------------

!      do j=1,nlat
!        do i=1,nlon
!          if ((hi(i,j) < -6000.0_dp).or.(hi(i,j) > 8000.0_dp)) then
!            WRITE(*,*) 'Blowing up!!!  dyn_full,  time ', time
!            WRITE(*,*) 'i, j, hi, dhdt '
!            WRITE(*,*)  i,j,hi(i,j),dhidt(k)
!            WRITE(*,*) 'balance= ',balance(i,j),' bmelt= ',bmelt(i,j)
!            WRITE(*,*) 'fluxlo = ',ftsht(i-1,j-1),' m^2/yr'
!            WRITE(*,*) 'fluxhi = ',ftsht(i-1,j)  ,' m^2/yr'
!            WRITE(*,*) 'fluxlt = ',ftsht(i-1,j-1),' m^2/yr'
!            WRITE(*,*) 'fluxrt = ',ftsht(i,j-1)  ,' m^2/yr'
!            STOP
!          endif
!        enddo
!      enddo

!-----------------------------------------------------------------------
!     adjust smelt rates from `potential melt' to true ablation
!-----------------------------------------------------------------------

!      imargin = 0
      do j=2,nlat-1
        jj = j-1
        do i=2,nlon-1
          ij = i-1
          if (Hice(i,j) < zerop) then
            fluxin = Bjvect(j)*((fpsht(i,jj) - fpsht(ij,jj))*dy & ! m^3/a
                + (ftsht(ij,jj)*delxhi(jj) - ftsht(ij,j) &
                  *delxhi(j))/Cjvect(j))
            icein = acc(i,j) + fluxin/area(j)                   ! m/a
            smelt(i,j) = icein
            if (fluxin > c0) then                       ! Marginal cell
!              imargin(i,j) = 1
            endif
          endif
        enddo
      enddo

!-----------------------------------------------------------------------
!     store new fluxes as old
!-----------------------------------------------------------------------

      ftshtk = ftsht
      fpshtk = fpsht
      if ((islid > 0) .or. (ishelf > 2)) then     ! Save basal velocities
        ubk = ub
        vbk = vb
      endif

!-----------------------------------------------------------------------
!     find vertical velocity field for sheet/stream ice
!-----------------------------------------------------------------------

#if !defined uvic_embm
      if (ltdcur.or.(time == etime)) then

        call wfield(vt,vp,wvel,hg,hi,Hice,Hicek,dhgdt,bmelt)

        ! Update bed coverage for permafrost evolution model
        do j=1,nlat
          do i=1,nlon
            if (Hice(i,j) < zerop) then
              icover(i,j) = 0           ! Subaerial
            else
              icover(i,j) = 1           ! Ice present
            endif
          enddo
        enddo

      endif

#endif
!-----------------------------------------------------------------------
!     deallocate workspace
!-----------------------------------------------------------------------

      DEALLOCATE (Hvect)
      DEALLOCATE (Hvectk)
      DEALLOCATE (Hvimp)
      DEALLOCATE (hivect)
      DEALLOCATE (hivectk)
      DEALLOCATE (hivimp)
      DEALLOCATE (resd)
      DEALLOCATE (deld)
      DEALLOCATE (jacd)
      DEALLOCATE (ijacd)

!=======================================================================
      end subroutine is_dyn
!=======================================================================
