!****************** Numerical Recipes routine ****************************
!   (C) Copr. 1986-92 Numerical Recipes Software 5,29#
!   Uses user-supplied routines atimes, asolve, snrm
!   SJM: 95-11-14.  Modify to explicitly include sparse matrix.
!   Routines atimes, snrm, asolve modified accordingly.

!   Solve system Ax = b for x(1:nsys) given b(1:nsys).  On input,
!      x(1:nsys) should be the initial guess to the solution.
!      itol = 1,2,3,4 specifies which convergence test is applied.
!   itmax is the maximum number of iterations allowed and
!   tol is the desired convergence.   On output, x(1:nsys) is reset
!   to the improved solution and iterb is the number of iterations
!   required to get there.  ncc is the physical size of the
!   sparse matrices

!**************************************************************************
    subroutine linbcg(jac,ijac,njac,bvec,xvec,nsys,ncc,&
                      itol,tol,itmax,err,iterb)

!****************************************************************************
      USE global_param
      implicit none
      INTEGER, INTENT(IN) :: njac,nsys,itmax,itol,ncc
      INTEGER, INTENT(IN) :: ijac(njac)
      INTEGER, INTENT(OUT) :: iterb
      REAL(KIND=dp), INTENT(IN) :: jac(njac),bvec(nsys),tol
      REAL(KIND=dp), INTENT(INOUT) :: xvec(nsys),err

      ! Local variables
      integer :: j,itrnsp
!!!      INTEGER, parameter :: nmax=11000
      REAL(KIND=dp), parameter :: eps=1.e-20_dp
      REAL(KIND=dp) :: ak,akden,bk,bkden,bknum,bnrm,dxnrm,xnrm,zm1nrm,znrm
!!!                       p(nmax),pp(nmax),r(nmax),rr(nmax),z(nmax),zz(nmax)
      REAL(KIND=dp), ALLOCATABLE, DIMENSION(:) :: p,pp,r,rr,z,zz
      REAL(KIND=dp), EXTERNAL :: snrm

!**************************************************************************
      ALLOCATE (p(nsys),pp(nsys),r(nsys),rr(nsys),z(nsys),zz(nsys))
      p=c0 ; pp=c0 ; r=c0 ; rr=c0 ; z=c0 ; zz=c0

      iterb = 0
      err = c1
      itrnsp = 0                ! Calculate initial residual r
      call atimes(jac,ijac,njac,xvec,r,nsys,itrnsp)
      do j=1,nsys
        r(j) = bvec(j)-r(j)
        rr(j) = r(j)
      enddo

!     call atimes(jac,ijac,njac,xvec,r,nsys,itrnsp)
                ! Uncomment this to give min residual variant of algorithm
      znrm = c1
      if (itol == 1) then
        bnrm = snrm(bvec,nsys,itol)
      elseif (itol == 2) then
        call asolve(jac,ijac,njac,bvec,z,nsys,itrnsp)
        bnrm = snrm(z,nsys,itol)
      elseif (itol == 3.or.itol == 4) then
        call asolve(jac,ijac,njac,bvec,z,nsys,itrnsp)
        bnrm = snrm(z,nsys,itol)
        call asolve(jac,ijac,njac,r,z,nsys,itrnsp)
        znrm = snrm(z,nsys,itol)
      else
        pause 'illegal itol in linbcg'
      endif
      call asolve(jac,ijac,njac,r,z,nsys,itrnsp)

100   if (iterb <= itmax) then                        ! Iterative loop
        iterb = iterb + 1
        zm1nrm = znrm
        itrnsp = 1
        call asolve(jac,ijac,njac,rr,zz,nsys,itrnsp)
        bknum = c0
        do j=1,nsys
          bknum=bknum+z(j)*rr(j)
        enddo
        if (iterb == 1) then
          do j=1,nsys
            p(j) = z(j)
            pp(j) = zz(j)
          enddo
        else
          bk=bknum/bkden
          do j=1,nsys
            p(j) = bk*p(j)+z(j)
            pp(j) = bk*pp(j)+zz(j)
          enddo
        endif
        bkden = bknum

        itrnsp = 0
        call atimes(jac,ijac,njac,p,z,nsys,itrnsp)
        akden = c0
        do j=1,nsys
          akden = akden+z(j)*pp(j)
        enddo
        ak=bknum/akden

        itrnsp = 1
        call atimes(jac,ijac,njac,pp,zz,nsys,itrnsp)
        do j=1,nsys
          xvec(j) = xvec(j) + ak*p(j)
          r(j) = r(j) - ak*z(j)
          rr(j) = rr(j) - ak*zz(j)
        enddo
        itrnsp = 0
        call asolve(jac,ijac,njac,r,z,nsys,itrnsp)
        if ((itol == 1).or.(itol == 2)) then
          znrm = c1
          err = snrm(r,nsys,itol)/bnrm
        elseif ((itol == 3).or.(itol == 4)) then
          znrm = snrm(z,nsys,itol)
          if (ABS(zm1nrm-znrm) > eps*znrm) then
            dxnrm = ABS(ak)*snrm(p,nsys,itol)
            err = znrm/ABS(zm1nrm-znrm)*dxnrm
          else
            err = znrm/bnrm
            GOTO 100
          endif
          xnrm = snrm(xvec,nsys,itol)
          if (err <= r2*xnrm) then
            err = err/xnrm
          else
            err = znrm/bnrm
            GOTO 100
          endif
        endif
!       WRITE (*,*) ' iterb=', iterb, ' err=', err

        if (err > tol) GOTO 100
      endif

      DEALLOCATE (p,pp,r,rr,z,zz)

!***************************************************************************
    end subroutine linbcg
!***************************************************************************
