!**********************************************************************
!   Load geothermal heat flux field (W/m^2), from file nahtgr.dat.
!   Data from DNAG North American geothermal maps (GSA),
!   with hints from Trevor Lewis.

    subroutine loadgeo(geo)

!**********************************************************************
      USE global_param
      implicit none
      REAL(dp), INTENT(INOUT) :: geo(nlon,nlat)

      ! Local variables
      REAL(dp) :: gtflux
      integer :: i,j,ndata

      if (iheat == 1) then           ! Specify
        geo = .045_dp*year

      else                           ! Load gt flux map
        READ (63,*)
        READ (63,*)
        READ (63,*)
        READ (63,*)
        READ (63,*)
        READ (63,*)
        do j=1,nlat
          READ (63,*)
          READ(63,100) (geo(i,j), i=1,nlon)
        enddo
        geo = geo*year/1000.0_dp
      endif
      CLOSE (63)
 100  FORMAT(15(8f8.3,/))

!***********************************************************************
    end subroutine loadgeo
!***********************************************************************
