!**************************************************************************
!   Calculate linear interpolation of variables used in the
!   nested time loop in tfield.  Generic: for sheet or stream
!   ice calculations.

    subroutine setnest(hi,hikt,Hice,Hicekt,hg,hgkt,nestt,dhndt,dhsdt,&
                       dhedt,dhwdt,dhidt,dhgdt,dhhdt,hipijcur,hitijcur,&
                       hipijk,hitijk,dhipijdt,dhitijdt,dhtndt,dhtsdt,&
                       dhtedt,dhtwdt,dhtnedt,dhtnwdt,dhtsedt,dhtswdt,&
                       i,j,ij,jj)

!**************************************************************************
      USE global_param
      implicit none
      INTEGER, INTENT(IN) :: nestt,i,j,ij,jj
      REAL(dp), INTENT(IN) :: hi(nlon,nlat),hikt(nlon,nlat),&
                              hg(nlon,nlat),hgkt(nlon,nlat),&
                              Hice(nlon,nlat),Hicekt(nlon,nlat)
      REAL(dp), INTENT(OUT) :: hipijcur,hitijcur,dhidt,dhgdt,dhhdt,&
                               dhndt,dhsdt,dhedt,dhwdt,hipijk,hitijk,&
                               dhipijdt,dhitijdt,dhtndt,dhtsdt,dhtedt,&
                               dhtwdt,dhtnedt,dhtnwdt,dhtsedt,dhtswdt

!**************************************************************************

      hipijcur = (hi(i+1,j)-hi(ij,j))/(c2*delx(j))      ! Gradients
      hitijcur = (hi(i,jj)-hi(i,j+1))/(c2*dy)
      hipijk = (hikt(i+1,j)-hikt(ij,j))/(c2*delx(j))    ! Gradients
      hitijk = (hikt(i,jj)-hikt(i,j+1))/(c2*dy)

      dhidt = (hi(i,j)-hikt(i,j))/deltt               ! Rates of change
      dhgdt = (hg(i,j)-hgkt(i,j))/deltt
      dhhdt = dhidt - dhgdt

      if (nestt > 1) then       ! Inner loops required

        ! Projected rates of change
        dhndt = (Hice(i,j+1)-Hicekt(i,j+1))/deltt
        dhsdt = (Hice(i,jj)-Hicekt(i,jj))/deltt
        dhedt = (Hice(i+1,j)-Hicekt(i+1,j))/deltt
        dhwdt = (Hice(ij,j)-Hicekt(ij,j))/deltt

        dhtndt = (hi(i,j+1)-hikt(i,j+1))/deltt
        dhtsdt = (hi(i,jj)-hikt(i,jj))/deltt
        dhtedt = (hi(i+1,j)-hikt(i+1,j))/deltt
        dhtwdt = (hi(ij,j)-hikt(ij,j))/deltt

        dhtnwdt = (hi(i+1,j+1)-hikt(i+1,j+1))/deltt
        dhtnedt = (hi(ij,j+1)-hikt(ij,j+1))/deltt
        dhtswdt = (hi(i+1,jj)-hikt(i+1,jj))/deltt
        dhtsedt = (hi(ij,jj)-hikt(ij,jj))/deltt

        dhipijdt = (hipijcur-hipijk)/deltt
        dhitijdt = (hitijcur-hitijk)/deltt

      endif

!***************************************************************************
    end subroutine setnest
!***************************************************************************
