!**********************************************************************
!   Calculate ice shelf geometry and velocities

    subroutine shelf_front(ub,vb,ubk,vbk,Hice,fpshtk,ftshtk,Bbar,pice,&
                           thinice,ifloating,time)

!**********************************************************************
      USE shelf_arrays
      implicit none
      INTEGER, INTENT(IN) :: time
      INTEGER, INTENT(IN), DIMENSION(nlon,nlat) :: ifloating
      REAL(dp), INTENT(IN) :: thinice
      REAL(dp), INTENT(IN), DIMENSION(nlon,nlat) :: Hice,Bbar,pice
      REAL(dp), INTENT(IN), DIMENSION(nlon-1,nlatp) :: fpshtk,ubk
      REAL(dp), INTENT(IN), DIMENSION(nlonp,nlat-1) :: ftshtk,vbk
      REAL(dp), INTENT(INOUT), DIMENSION(nlon-1,nlatp) :: ub
      REAL(dp), INTENT(INOUT), DIMENSION(nlonp,nlat-1) :: vb

      ! Local variables
      integer :: i,ij,j,jj,ip,jp
      REAL(dp) :: uwest,ueast,vnorth,vsouth

!********************************************************
      do j=3,nlatp
        jj = j-1
        jp = j+1
        do i=3,nlonp
          ij = i-1
          ip = i+1

          if ((ifloating(i,j)==1) .and. (Hice(i,j) > thinice)) then

            ! Find floating outlet position, geometry
            if (Hice(ip,j) < zerop) then        ! Eastern front
              icefront(1,i,j) = 1
              if (Hice(i,jp) < zerop) then          ! Northern front
                icefront(2,i,j) = 1
                if (Hice(ij,j) < zerop) then            ! Western front
                  icefront(3,i,j) = 1
                  if (Hice(i,jj) < zerop) then              ! Southern front
                    icefront(4,i,j) = 1
                    nfront(i,j) = 1234          ! Isolated cell, all fronts
                  else
                    nfront(i,j) = 123     ! Three calving fronts, ENW
                  endif
                else
                  if (Hice(i,jj) < zerop) then              ! Southern front
                    icefront(4,i,j) = 1
                    nfront(i,j) = 124     ! Three calving fronts, ENS
                  else
                    nfront(i,j) = 12      ! Two calving fronts, EN
                  endif
                endif
              else
                if (Hice(ij,j) < zerop) then            ! Western front
                  icefront(3,i,j) = 1
                  if (Hice(i,jj) < zerop) then              ! Southern front
                    icefront(4,i,j) = 1
                    nfront(i,j) = 134          ! Three calving fronts, EWS
                  else
                    nfront(i,j) = 13      ! Two calving fronts, EW
                  endif
                else
                  if (Hice(i,jj) < zerop) then              ! Southern front
                    icefront(4,i,j) = 1
                    nfront(i,j) = 14      ! Two calving fronts, ES
                  else
                    nfront(i,j) = 1       ! One calving front, E
                  endif
                endif
              endif

!********************************************************
            else                        ! No Eastern front
              if (Hice(i,jp) < zerop) then          ! Northern front
                icefront(2,i,j) = 1
                if (Hice(ij,j) < zerop) then            ! Western front
                  icefront(3,i,j) = 1
                  if (Hice(i,jj) < zerop) then              ! Southern front
                    icefront(4,i,j) = 1
                    nfront(i,j) = 234          ! Three calving fronts, NWS
                  else
                    nfront(i,j) = 23      ! Two calving fronts, NW
                  endif
                else
                  if (Hice(i,jj) < zerop) then              ! Southern front
                    icefront(4,i,j) = 1
                    nfront(i,j) = 24      ! Two calving fronts, NS
                  else
                    nfront(i,j) = 2       ! One calving fronts, N
                  endif
                endif
              else
                if (Hice(ij,j) < zerop) then            ! Western front
                  icefront(3,i,j) = 1
                  if (Hice(i,jj) < zerop) then              ! Southern front
                    icefront(4,i,j) = 1
                    nfront(i,j) = 34          ! Two calving fronts, WS
                  else
                    nfront(i,j) = 3       ! One calving fronts, W
                  endif
                else
                  if (Hice(i,jj) < zerop) then              ! Southern front
                    icefront(4,i,j) = 1
                    nfront(i,j) = 4       ! One calving fronts, S
                  else
                    nfront(i,j) = 0       ! No calving fronts
                  endif
                endif
              endif

            endif

!************************************************************
            ! Calculate outlet velocities for floating front
            if (nfront(i,j) > 0)  then
              ioutlet(i,j) = 1

!*******************************************
              ! Assign east-west velocities
              SELECT CASE (nfront(i,j))
              CASE(1,12,14,124)                ! simple eastern outlet
                if (ifloating(ij,j) == 0) then
                  ! western neighbour grounded
                  uwest = -fpshtk(ij,jj)*c2/(Hice(i,j)+Hice(ij,j))
                else
                  uwest = ubk(ij,jj)
                endif
                ub(i,jj) = uwest + delx(j)/(c2*Bbar(i,j)) &
                               *(r2*iceberg*pice(i,j) - taumar(1,i,j))

              CASE(13,123,134,1234)        ! E-W outlets
                ub(i,jj) =   delx(j)/(c4*Bbar(i,j)) &
                               *(r2*iceberg*pice(i,j) - taumar(1,i,j))
                ub(ij,jj) = -delx(j)/(c4*Bbar(i,j)) &
                               *(r2*iceberg*pice(i,j) - taumar(1,i,j))

              CASE(3,23,34,234)                ! simple western outlet
                if (ifloating(ip,j) == 0) then
                  ! eastern neighbour grounded
                  ueast = -fpshtk(i,jj)*c2/(Hice(i,j)+Hice(ip,j))
                else
                  ueast = ubk(i,jj)
                endif
                ub(ij,jj) = ueast - delx(j)/(c2*Bbar(i,j)) &
                               *(r2*iceberg*pice(i,j) - taumar(1,i,j))

              CASE(2,4,24)                        ! N-S outlets only
                ub(ij,jj) = c0
                ub(i,jj) = c0

              CASE DEFAULT
                WRITE(45,*) 'Improper case, nfront = ', nfront(i,j)
                WRITE(45,*) '  point ', i,j, 'time = ', time
                STOP
              end SELECT

!*******************************************
              ! Assign north-south velocities
              SELECT CASE (nfront(i,j))
              CASE(2,12,23,123)                ! simple northern outlet
                if (ifloating(i,jj) == 0) then
                  ! southern neighbour grounded
                  vsouth = -ftshtk(ij,jj)*c2/(Hice(i,j)+Hice(i,jj))
                else
                  vsouth = vbk(ij,jj)
                endif
                vb(ij,j) = vsouth - dy/(c2*Bbar(i,j)) &
                               *(r2*iceberg*pice(i,j) - taumar(2,i,j))

              CASE(24,124,234,1234)                ! N-S outlets
                vb(ij,j) =  -dy/(c4*Bbar(i,j)) &
                               *(r2*iceberg*pice(i,j) - taumar(2,i,j))
                vb(ij,jj) =  dy/(c4*Bbar(i,j)) &
                               *(r2*iceberg*pice(i,j) - taumar(2,i,j))

              CASE(4,14,34,134)                        ! simple southern outlet
                if (ifloating(i,jp) == 0) then
                  ! northern neighbour grounded
                  vnorth = -ftshtk(ij,j)*c2/(Hice(i,j)+Hice(i,jp))
                else
                  vnorth = vbk(ij,j)
                endif
                vb(ij,jj) = vnorth + dy/(c2*Bbar(i,j)) &
                               *(r2*iceberg*pice(i,j) - taumar(2,i,j))

              CASE(1,3,13)                        ! E-W outlets only
                vb(ij,jj) = c0
                vb(ij,j) = c0

              CASE DEFAULT
                WRITE(45,*) 'Improper case, nfront = ', nfront(i,j)
                WRITE(45,*) '  point ', i,j, 'time = ', time
                STOP
              end SELECT

!***************************************************************************
             endif                ! nfront ifblock

!***************************************************************************
          endif              ! ifloating ifblock

        enddo
      enddo

!***************************************************************************
    end subroutine shelf_front
!***************************************************************************
