!*************************************************************************
!   Function called by Numerical Recipes linbcg to calculate residual norm.
!   Modified from the NR code, p. 81.
!   Computes vector magnitude norm (itol.le.3) or largest
!   component norm (itol.eq.4)

    FUNCTION snrm(bvec,njac,itol)

!*************************************************************************
      USE global_param
      implicit none
      REAL(KIND=dp) :: snrm
      INTEGER, INTENT(IN) :: njac,itol
      REAL(KIND=dp), INTENT(IN) :: bvec(njac)

      ! Local variables
      integer :: i,ibmax

!*************************************************************************
      if (itol <= 3) then                  ! L_2 norm
         snrm = 0.d0
         do i=1,njac
           snrm = snrm + bvec(i)**2
         enddo
         snrm = SQRT(snrm)

      elseif (itol == 4) then             ! L_1 norm
         ibmax = 1
         do i=1,njac
           if (ABS(bvec(i)) > ABS(bvec(ibmax))) ibmax = i
         enddo
         snrm = ABS(bvec(ibmax))

      endif

!***************************************************************************
    end FUNCTION snrm
!***************************************************************************
