!***********************************************************************
!   Calculates solution of implicit matrix system for thermodynamics
!   General solver for both sheet and stream ice; returns updated
!   field tice from the system:
!            tice = (coimp)^{-1} [coexp ticek + cocon]
!   Has option isol=(2/3) for tridiagonal or off-tridiagonal
!   system, contingent on lower boundary condition.  Uses general
!   tridiagonal solver calsol (in the tools library).

    subroutine solvet(tfij,tfijk,coimp,coexp,cocon,ij,jj,isol)

!***********************************************************************
      USE global_param
      implicit none
      INTEGER, INTENT(IN) :: ij,jj,isol
      REAL(KIND=dp), INTENT(IN) :: coimp(nvertp,nvertp),cocon(nvertp),&
                                   coexp(nvertp,nvertp),tfijk(nvertp)
      REAL(KIND=dp), INTENT(INOUT) :: tfij(nvertp)

      ! Local variables
#if defined uvic_ibm
      REAL(KIND=dp), DIMENSION(nvertp) :: xtvect,btvect,temp
#else
      REAL(KIND=dp), DIMENSION(SIZE(xi)) :: xtvect,btvect,temp
#endif
      integer :: nsys,l,k

!***********************************************************************
      nsys = nvertp
      temp = 0.0_dp
      xtvect = 0.0_dp
      btvect = 0.0_dp

      do l=1,nvertp            ! Convert system to form Ax=btvect
        if (l == 1) then
          do k = l,l+1
            temp(l) = temp(l) + coexp(l,k)*tfijk(k)
          enddo
        elseif (l == nvertp) then
          do k = l-2,l
            temp(l) = temp(l) + coexp(l,k)*tfijk(k)
          enddo
        else
          do k = l-1,l+1
            temp(l) = temp(l) + coexp(l,k)*tfijk(k)
          enddo
        endif
      enddo

      btvect = cocon + temp

      ! Solve matrix system; use homegrown tridiagonal solver
      call calsol(coimp,btvect,xtvect,nvertp,nsys,isol)

      ! Update tice
      tfij =  xtvect

!***************************************************************************
    end subroutine solvet
!***************************************************************************
