!****************************************************************************
! Assign  cell interface temperatures for the strain heating calculation.
! This version bases interface assignment on upstream direction.
! Incorporate correction for the pressure-softening de facto here
! (the flow law has no pressure effects in it).

  subroutine strain_int(tice,ttt,tpt,vtt,vpt,hi,Hice)

!****************************************************************************
    USE global_param
    implicit none
    REAL(dp), INTENT(IN), DIMENSION(nlon,nlat) ::  Hice,hi
    REAL(dp), INTENT(IN), DIMENSION(nvertp,nlonp,nlatp) :: tice
    REAL(dp), INTENT(IN), DIMENSION(nvertp,nlonp,nlat-1) :: vtt
    REAL(dp), INTENT(IN), DIMENSION(nvertp,nlon-1,nlatp) :: vpt

    REAL(dp), INTENT(OUT), DIMENSION(2:nvertp,nlonp,nlat-1) :: ttt
    REAL(dp), INTENT(OUT), DIMENSION(2:nvertp,nlon-1,nlatp) :: tpt

    ! Local
    integer :: i,j,ij,jj,k
    REAL(dp) :: tmcorr,Hlt,Hlo

!****************************************************************************
    ! Assign lower and left interfaces
    do jj=2,nlatp
      j = jj+1
      do ij=2,nlonp
        i = ij+1

!***************************************
        ! Left interface
        Hlt = r2*(Hice(i,j) + Hice(ij,j))

        if (Hice(i,j) < zerop) then        !! No ice, assign upstream T or null

          if (Hlt < zerop) then           ! No zonal flux
            do k=2,nvertp
              tpt(k,ij,jj) = tnoice
            enddo
          else                                   ! Default Eward
            do k=2,nvertp
              tmcorr = fptdep*Hlt*xi(k)
              tpt(k,ij,jj) = MIN(tice(k,ij-1,jj) + tmcorr, triplept)
            enddo
          endif

        else                                !! Ice present; look for upstream

          if (ij == nlonp) then            ! Default Eward
            do k=2,nvertp
              tmcorr = fptdep*Hlt*xi(k)
              tpt(k,ij,jj) = MIN(tice(k,ij-1,jj) + tmcorr, triplept)
            enddo

          else                                   ! Interior
            if (hi(i,j) < hi(ij,j)) then               ! Eastward flow
              do k=2,nvertp
                tmcorr = fptdep*Hlt*xi(k)
                tpt(k,ij,jj) = MIN(tice(k,ij-1,jj) + tmcorr, triplept)
              enddo
            elseif (hi(i,j) > hi(ij,j)) then          ! Westward flow
              do k=2,nvertp
                tmcorr = fptdep*Hlt*xi(k)
                tpt(k,ij,jj) = MIN(tice(k,ij,jj) + tmcorr, triplept)
              enddo
            else                                               ! No flow
                 do k=2,nvertp
                tmcorr = fptdep*Hlt*xi(k)
                tpt(k,ij,jj) = MIN(r2*(tice(k,ij,jj) + tice(k,ij-1,jj)) &
                                               + tmcorr, triplept)
              enddo
            endif
          endif          ! Boundary block
        endif                ! If ice block

!***************************************
        ! Lower interface
        Hlo = r2*(Hice(i,j) + Hice(i,jj))

        if (Hice(i,j) < zerop) then        !! No ice here
                                        !! Assign upstream or null T

          if (Hlo < zerop) then           ! No meridional flux
            do k=2,nvertp
              ttt(k,ij,jj) = tnoice
            enddo
          else                                   ! Default Northward
            do k=2,nvertp
              tmcorr = fptdep*Hlo*xi(k)
              ttt(k,ij,jj) = MIN(tice(k,ij,jj-1) + tmcorr, triplept)
            enddo
          endif

        else                                !! Ice present; look for upstream

          if (jj == nlatp) then           ! Default Northward
            do k=2,nvertp
              tmcorr = fptdep*Hlo*xi(k)
              ttt(k,ij,jj) = MIN(tice(k,ij,jj-1) + tmcorr, triplept)
            enddo

          else                                  ! Interior
            if (hi(i,j) > hi(i,jj)) then                ! Southward flow
              do k=2,nvertp
                tmcorr = fptdep*Hlo*xi(k)
                ttt(k,ij,jj) = MIN(tice(k,ij,jj) + tmcorr, triplept)
              enddo
            elseif (hi(i,j) < hi(i,jj)) then                ! Northward flow
              do k=2,nvertp
                tmcorr = fptdep*Hlo*xi(k)
                ttt(k,ij,jj) = MIN(tice(k,ij,jj-1) + tmcorr, triplept)
              enddo
            else
              do k=2,nvertp
                tmcorr = fptdep*Hlo*xi(k)
                ttt(k,ij,jj) = MIN(r2*(tice(k,ij,jj) + tice(k,ij,jj-1)) &
                                             + tmcorr, triplept)
              enddo
            endif
          endif          ! Boundary block
        endif                ! If ice block

      enddo
    enddo

!****************************************************************************
  end subroutine strain_int
!****************************************************************************
