!=======================================================================
!     define consants and arrays for subgrid surface mass balance
!     calculation

!     constants:
!     mi = the ratio of number of longitudinal sub-grids to a grid
!     mj = the ratio of number of latitudinal sub-grids to a grid
!     imint = minimum longitude of concerned area
!     imaxt = maximum longitude of concerned area
!     jmint = minimum latitude of concerned area
!     jmaxt = maximum latitude of concerned area
!     iimt = total number of longitudinal sub-grids
!     jjmt = total number of latitudinal sub-grids

!     arrays:
!     subhice = sub-grids ice thickness
!     subelev = sub-grids elevation
!     subpsno = sub-grids snowfall
!     subhsno = sub-grids snow thickness

!     based on code by: M. Yoshimori
!=======================================================================

#if defined uvic_embm && defined ubc_cidm
      integer mi,mj,imint,imaxt,jmint,jmaxt,iimt,jjmt
      parameter (mi=1,mj=1,imint=1,imaxt=102,jmint=1,jmaxt=102)
      parameter (iimt=(imaxt-imint+1)*mi,jjmt=(jmaxt-jmint+1)*mj)

      integer l,m,ii,jj,kk,iloop,nloop
      real degrad,phij,phijj
     &,    ttlhsno,suboutlwr,subqmax,subat,sumat,subasno
      real area(1:102),subarea(1:jjmt),subhice(1:iimt,1:jjmt)
     &,    subelev(1:iimt,1:jjmt),subssh(1:iimt,1:jjmt)
     &,    subprecip(1:iimt,1:jjmt),subpsno(1:iimt,1:jjmt)
     &,    subaice(1:iimt,1:jjmt),avg_calv(1:iimt,1:jjmt)
     &,    avg_ltnt(1:iimt,1:jjmt),subhsno(1:iimt,1:jjmt,1:3)

      common /subgrid_i/ l,m,ii,jj,kk,iloop,nloop
      common /subgrid_r0/ degrad,phij,phijj,ttlhsno,suboutlwr,subqmax
     &,                   subat,sumat,subasno
      common /subgrid_r1/ area,subarea
      common /subgrid_r2/ subhice,subelev,subssh,subprecip
     &,                   subpsno,subaice,avg_calv,avg_ltnt
      common /subgrid_r3/ subhsno
#endif
