!*************************************************************************
!   Declare arrays for use in subgrid (hypsometric) mass balance

    MODULE subgrid_arrays

!**************************************************************************
      USE global_param
      implicit none
      SAVE

      ! Subgrid mass balance arrays
      REAL(dp), ALLOCATABLE, DIMENSION(:,:,:), SAVE :: &
                 pddsub,&        ! Subgrid annual degree-days (\degC d)
                 meltsub,&       ! Subgrid surface melt rate (m/a)
                 accsub,&        ! Subgrid surface accumulation rate (m/a)
                 balsub,&        ! Subgrid mass balance (m/a)
                 icesub,&        ! Subgrid ice accumulation (m)
                 hsub,&          ! Divisions, subgrid hypsometry
                 wtsub           ! Weights, subgrid hypsometry

      ! Subgrid cell attributes
      REAL(dp), ALLOCATABLE, DIMENSION(:,:), SAVE :: &
                 rough,&         ! Topographic roughness (Log)
                 bedcoup,&       ! Bed coupling coefficient
                 Heff,&          ! Effective ice thickness (m)
                 hmin,&          ! Minimum cell height (m)
                 hmax,&          ! Maximum cell height (m)
                 hmean,&         ! Mean cell elevation (m)
                 range,&         ! Range in cell topography (m)
                 hypso           ! Cell hypsometry

!**************************************************************************
   end MODULE subgrid_arrays
!**************************************************************************
