      subroutine gasbc (is, ie, js, je)

!=======================================================================
!     calculate boundary conditions for the atmospheric model

!     based on code by: A. Fanning and M. Eby
!=======================================================================
#if defined uvic_embm

      implicit none

# include "param.h"
# include "coord.h"
# include "csbc.h"
# include "ice.h"
# include "switch.h"
# include "tmngr.h"
# include "cembm.h"
# include "atm.h"
# include "insolation.h"
# include "calendar.h"
# include "grdvar.h"
# if defined uvic_embm_adv_q
#  include "solve.h"
# endif
# if defined uvic_mtlm
#  include "mtlm.h"
# endif

      integer i, ie, iem1, is, isp1, j, je, jem1, js, jsp1, l

      real sss, phlo, phhi, sit_in, pt_in, atmpres, xconv, ta_in
      real ph, co2_in, co2star, dco2star, dco2surf, dpco2, pco2surf
      real scco2, piston_vel, avgflxc, fa, calday
# if !defined uvic_embm_annual
      real cosz(is:ie,js:je)
# endif
# if defined uvic_carbon_coupled
      real dmsk((is:ie,js:je)
# endif

      isp1 = is + 1
      iem1 = ie - 1
      jsp1 = js + 1
      jem1 = je - 1

# if defined uvic_carbon
      phlo = 6.
      phhi = 9.
      sit_in = 7.6875e-03 !mol/m^3
      pt_in = 0.5125e-3   !mol/m^3
      atmpres = 1.0       !atm
      xconv = 31.5/3.6e+05
      co2flx = 0.
!     fa is used in converting g carbon cm-2 => ppmv CO2
!     4.138e-7 => 12e-6 g/umol carbon / 29 g/mol air
      fa = 1./(4.138e-7*rhoatm*shc)
# endif
# if defined uvic_embm_adv_q

!-----------------------------------------------------------------------
!     average precipitaion and zero accumulator
!-----------------------------------------------------------------------
      avgp(:,:) = accp(:,:)/(segtim*daylen)
      accp(:,:) = 0.0
# endif

!-----------------------------------------------------------------------
!     zero totals for new accumulation
!-----------------------------------------------------------------------
      atatm = 0.
      flux(:,:,:) = 0.
# if defined llnl_plume
      subflux(:,:,:) = 0.
# endif
# if defined uvic_convect_brine
      cbf(:,:,:) = 0.
      cba(:,:,:) = 0.
# endif
      sbc(:,:,iro) = 0.
# if defined uvic_mtlm
      sbc(:,:,iat) = 0.
      sbc(:,:,irh) = 0.
      sbc(:,:,ipr) = 0.
      sbc(:,:,ips) = 0.
      sbc(:,:,iaws) = 0.
      sbc(:,:,iswr) = 0.
# endif
# if defined uvic_carbon
      sbc(:,:,icflx) = 0.
# endif
# if defined uvic_embm_solardata || defined uvic_embm_solardata_transient

!-----------------------------------------------------------------------
!     set solar constant
!-----------------------------------------------------------------------
      call solardata
# endif
# if defined uvic_embm_co2data || defined uvic_embm_co2data_transient

!-----------------------------------------------------------------------
!     set co2 concentration
!-----------------------------------------------------------------------
      call co2data
# endif

      do j=jsp1,jem1
        do i=isp1,iem1

          if (tmsk(i,j) .ge. 0.5) then

!-----------------------------------------------------------------------
!           calculate freezing point of sea water using UNESCO (1983)
!-----------------------------------------------------------------------
            sss = 1000.0*sbc(i,j,isss) + 35.0
            frzpt(i,j) = -.0575*sss + 1.710523e-3*sss**1.5
     &                   - 2.154996e-4*sss**2

# if defined uvic_carbon
#  if defined uvic_mom
!-----------------------------------------------------------------------
!           calculate ocean surface flux of carbon
!-----------------------------------------------------------------------
            ta_in = sss*2.36775/(socn*1000.)   !surface ref alk
#   if defined uvic_carbon_co2_2d
            co2_in = at(i,j,2,ico2)
#   else
            co2_in = co2ccn
#   endif

            call co2calc (sbc(i,j,isst), sss, sbc(i,j,issc)
     &,       ta_in, pt_in, sit_in, phlo, phhi, ph, co2_in, atmpres
     &,       co2star, dco2star, pCO2surf, dpco2)

!           calculate Schmidt number (of co2 = 660 at t = 20 in sea water)
!           based on SST. from Wanninkhof:  Sc = A - Bt + Ct^2 - Dt^3
            scco2 = 2073.1 - 125.62*sbc(i,j,isst)
     &            + 3.6276*sbc(i,j,isst)**2.0
     &            - 0.043219*sbc(i,j,isst)**3.0

!           xconv is constant to convert piston_vel from cm/hr -> cm/s
!           wind speed spd(i,j) is converted from cm/s -> m/s
            piston_vel = xconv*((sbc(i,j,iws)*0.01)**2.)
     &                  *((scco2/660.)**(-0.5))*(1.0 - aice(i,j,1))

!           dic in umol cm-3 or (mol m-3) => flux in umol cm-2 s-1
            sbc(i,j,icflx) = piston_vel*dco2star
#   if defined uvic_carbon_co2_2d && defined uvic_carbon_coupled
!           convert from umol cm-2 s-1 => ppmv s-1
            flux(i,j,ico2) = sbc(i,j,icflx)*12.e-6*fa
     &                     + flux(i,j,ico2)
#   endif
#  endif

#  if defined uvic_mtlm && defined uvic_carbon_coupled
          else
!-----------------------------------------------------------------------
!           calculate land surface flux of carbon
!-----------------------------------------------------------------------
#   if defined uvic_carbon_co2_2d
!           convert from kg m-2 s-1 => ppmv s-1
            flux(i,j,ico2) = (sbc(i,j,inpp) - sbc(i,j,isr))*0.1*fa
     &                     + flux(i,j,ico2)
#   else
!           convert from kg m-2 s-1 => umol cm-2 s-1
            sbc(i,j,icflx) = (sbc(i,j,inpp) - sbc(i,j,isr))*0.1/12.e-6
#   endif
#  endif

# endif
          endif
        enddo
      enddo

# if !defined uvic_embm_annual
!-----------------------------------------------------------------------
!     update insolation for the current day
!-----------------------------------------------------------------------
!     subroutine decl is expecting a 365.25 day year
      calday = dayoyr*365.25/yrlen
      call decl (calday, eccen, obliq, mvelp, lambm0, sindec, eccf)
      i = (ie-is+1)*(je-js+1)
      call zenith (i, c0, daylen, daylen, tlat, tlon, sindec, cosz)
      solins(:,:) = solarconst*eccf*cosz(:,:)

# endif
!-----------------------------------------------------------------------
!     update any atmospheric data
!-----------------------------------------------------------------------
# if defined time_mean_sbc_data
      if (pcfactor .gt. 0.001) call albedo
#  if defined uvic_ice_evp || defined uvic_embm_astress
      sbc(:,:,itaux) = taux(:,:)
      sbc(:,:,itauy) = tauy(:,:)
#  endif
#  if defined uvic_embm_adv_q && defined uvic_embm_astress
      sbc(:,:,iwx) = wx(:,:)
      sbc(:,:,iwy) = wy(:,:)
#  endif
#  if defined uvic_embm_astress
      sbc(:,:,iws) = ws(:,:)
#  endif
# elif defined time_varying_sbc_data
      call atmos
      call albedo
# endif
# if defined uvic_embm_astress

!-----------------------------------------------------------------------
!     calculate winds with new feedback
!-----------------------------------------------------------------------
      call add_astress (is, ie, js, je)

# endif
# if defined uvic_carbon

!-----------------------------------------------------------------------
!     set boundary conditions for carbon
!-----------------------------------------------------------------------
      call setbcx (sbc(1,1,icflx), imt, jmt)
#  if defined uvic_carbon_co2_2d
      call setbcx (flux(1,1,ico2), imt, jmt)
#  elif defined uvic_carbon_coupled
      dmsk(:,:) = 1.
      call areaavg (sbc(1,1,icflx), dmsk, avgflxc)
      co2flx = co2flx + avgflxc
      co2ccn = co2ccn - co2flx*segtim*12.e-6*daylen*fa
#  endif
# endif

!-----------------------------------------------------------------------
!     calcualte CO2 forcing
!-----------------------------------------------------------------------
      call co2forc
# if defined uvic_embm_adv_q

!-----------------------------------------------------------------------
!     set flags to calcualte new coefficients
!-----------------------------------------------------------------------
      newcoef(1,1) = .true.
      newcoef(2,1) = .true.
      newcoef(1,2) = .true.
      newcoef(2,2) = .true.
# endif
# if defined uvic_embm_crops_transient

!-----------------------------------------------------------------------
!     update boundary conditions over vegetation
!-----------------------------------------------------------------------
      call gvsbc
# endif
# if defined time_averages

!-----------------------------------------------------------------------
!     zero time averages if not in an averaging period
!-----------------------------------------------------------------------
      if (.not. timavgperts) call ta_embm_snap (is, ie, js, je, 0)
# endif
# if defined time_step_monitor

!-----------------------------------------------------------------------
!     zero time step integrals if not in an averaging period
!-----------------------------------------------------------------------
      if (.not. tsiperts) call ta_embm_tsi (0)
# endif
#endif

      return
      end
