      subroutine gosbc

!=======================================================================
!     calculate the average fluxes for next ocean time step

!     based on code by: A. Fanning and M. Eby
!=======================================================================

      implicit none

#if defined uvic_mom || defined uvic_embm
# include "param.h"
# include "csbc.h"
# if defined uvic_embm
#  include "cembm.h"
#  include "atm.h"
# endif
# if defined uvic_ice
#  include "ice.h"
# endif
# if defined uvic_mtlm
#  include "mtlm.h"
# endif

      integer i, j, nc

      real fa, fb, fc, fd

# if defined uvic_mom && defined uvic_embm
!-----------------------------------------------------------------------
!     calculate average net fluxes. convert heat flux to cal/cm**2/s
!     from kW/m**2 and fresh water flux (cm/s) to an apparent salt
!     flux (g/cm**2/s) using global ocean average salinity, socn
!-----------------------------------------------------------------------

      fa = 2.389e-8/atatm
      fb = -socn/atatm
      fc = 1./atatm
      do j=2,jmtm1
        do i=2,imtm1
          if (tmsk(i,j) .ge. 0.5) then
#  if defined llnl_plume
#   if defined llnl_plume_heat
            subflux(i,j,1) = flux(i,j,isat)
#   endif
#   if defined llnl_plume_salt
            subflux(i,j,2) = flux(i,j,ishum)
#   endif
            if (subflux(i,j,1) .gt. 0.) subflux(i,j,1) = 0.
            if (subflux(i,j,2) .gt. 0.) subflux(i,j,2) = 0.
#   if defined llnl_plume_all_heat
            subflux(i,j,1) = flux(i,j,isat)
#   endif
#   if defined llnl_plume_all_salt
            subflux(i,j,2) = flux(i,j,ishum)
#   endif
            flux(i,j,isat) = flux(i,j,isat) - subflux(i,j,1)
            subflux(i,j,1) = fa*subflux(i,j,1)
            flux(i,j,ishum) = flux(i,j,ishum) - subflux(i,j,2)
            subflux(i,j,2) = fb*subflux(i,j,2)
#  endif
#  if defined uvic_convect_brine
            cba0(i,j) = 0.
            do nc=0,ncat
              cba(i,j,nc) = fc*cba(i,j,nc)
              if (cba(i,j,nc) .gt. 0.) then
                cbf(i,j,nc) = fb*cbf(i,j,nc)/cba(i,j,nc)
                cba0(i,j) = cba0(i,j) + cba(i,j,nc)
              else
                cbf(i,j,nc) = 0.
                cba(i,j,nc) = 0.
              endif
            enddo
            if (cba0(i,j) .gt. 1.) then
              if (cba0(i,j) .gt. 1.000001) then
                print*, "==> Warning: ice area > 1: ", cba0(i,j)
                endif
              cba0(i,j) = 1.
            endif
            cba0(i,j) = 1. - cba0(i,j)
#  endif
#  if defined uvic_read_my_stf || defined restorst
            sbc(i,j,ihflx) = sbc(i,j,ihflx) + fa*flux(i,j,isat)
            sbc(i,j,isflx) = sbc(i,j,isflx) + fb*flux(i,j,ishum)
#  else
            sbc(i,j,ihflx) = fa*flux(i,j,isat)
            sbc(i,j,isflx) = fb*flux(i,j,ishum)
#  endif
          else
#  if defined llnl_plume
            subflux(i,j,1) = 0.
            subflux(i,j,2) = 0.
#  endif
#  if defined uvic_convect_brine
            cbf(i,j,:) = 0.
            cba(i,j,:) = 0.
            cba0(i,j) = 1.
#  endif
            sbc(i,j,ihflx) = 0.
            sbc(i,j,isflx) = 0.
          endif
          if (umsk(i,j) .ge. 0.5) then
#  if defined uvic_ice_evp || defined uvic_embm_astress
            sbc(i,j,itaux) = fc*flux(i,j,nat+1)
            sbc(i,j,itauy) = fc*flux(i,j,nat+2)
#  endif
          else
            sbc(i,j,itaux) = 0.
            sbc(i,j,itauy) = 0.
          endif
        enddo
      enddo

      call setbcx (sbc(1,1,ihflx), imt, jmt)
      call setbcx (sbc(1,1,isflx), imt, jmt)
      call setbcx (sbc(1,1,itaux), imt, jmt)
      call setbcx (sbc(1,1,itauy), imt, jmt)
#  if defined uvic_convect_brine
      do nc=0,ncat
        call setbcx (cbf(1,1,nc), imt, jmt)
        call setbcx (cba(1,1,nc), imt, jmt)
      enddo
      call setbcx (cba0, imt, jmt)
#  endif
# endif

!-----------------------------------------------------------------------
!     update boundary conditions from the land model
!     do this now instead of in gasbc so fields can be written out
!-----------------------------------------------------------------------

      fc = 0.
      fd = 0.
# if defined uvic_embm
      if (atatm .ne. 0.) fd = 1.0/atatm
# endif
# if defined uvic_mtlm
      if (atlnd .ne. 0.) fc = 1.0/atlnd
      do j=2,jmtm1
        do i=2,imtm1
          if (land_map(i,j) .ne. 0) then
            sbc(i,j,iro) = sbc(i,j,iro)*fc
            sbc(i,j,icalb) = sbc(i,j,icalb)*fc
            sbc(i,j,ievap) = sbc(i,j,ievap)*fc
            sbc(i,j,ilwr) = sbc(i,j,ilwr)*fc
            sbc(i,j,isens) = sbc(i,j,isens)*fc
#  if defined uvic_carbon
            sbc(i,j,inpp) =  sbc(i,j,inpp)*fc
            sbc(i,j,isr) =  sbc(i,j,isr)*fc
#  endif
          else
            sbc(i,j,iro) = sbc(i,j,iro)*fd
            sbc(i,j,ievap) = 0.
            sbc(i,j,ilwr) = 0.
            sbc(i,j,isens) = 0.
#  if defined uvic_mtlm && defined uvic_carbon
            sbc(i,j,inpp) = 0.
            sbc(i,j,isr) = 0.
#  endif
          endif
        enddo
      enddo
      call setbcx (sbc(1,1,icalb), imt, jmt)
      call setbcx (sbc(1,1,ievap), imt, jmt)
      call setbcx (sbc(1,1,ilwr), imt, jmt)
      call setbcx (sbc(1,1,isens), imt, jmt)
#  if defined uvic_carbon
      call setbcx (sbc(1,1,inpp), imt, jmt)
      call setbcx (sbc(1,1,isr), imt, jmt)
#  endif
# else
      sbc(:,:,iro) = sbc(:,:,iro)*fd
# endif
      call setbcx (sbc(1,1,iro), imt, jmt)

# if defined uvic_embm
      call rivmodel
# endif
#endif

      return
      end
