       subroutine co2data
!=======================================================================
!     routine to read and interpolate one dimensional forcing data
!     data is in ppmv CO2 or if uvic_carbon_coupled, Gt carbon/year

!     based on code by: M. Eby
!=======================================================================

      implicit none
#if defined uvic_embm_co2data || defined uvic_embm_co2data_transient

      integer iou, n, ln, ib(10), ic(10)

      logical exists

      real d(3), t(3), wt1, wt3

      real, allocatable :: data(:), time(:)

      save d, data, ln, t, time

#include "param.h"
#include "calendar.h"
#include "cembm.h"
#include "switch.h"
#include "tmngr.h"

      character(120) :: fname, name, new_file_name

      if (.not. allocated (time)) then
        name = "co2.nc"
        fname = new_file_name (name)
        inquire (file=trim(fname), exist=exists)
        if (.not. exists) then
          print*, "==> Warning: ", trim(fname), " does not exist."
          ln = 3
          allocate ( time(ln) )
          allocate ( data(ln) )
          time(:) = year0
          data(:) = co2ccn
        else
          call openfile (fname, iou)
          call getdimlen ('time', iou, ln)
          allocate ( time(ln) )
          allocate ( data(ln) )
          ib(:) = 1
          ic(:) = ln
          call getvara ('time', iou, ln, ib, ic, time, c1, c0)
          call getvara ('co2', iou, ln, ib, ic, data, c1, c0)
        endif
        t(:) = time(1)
        d(:) = data(1)
      endif

# if defined uvic_embm_co2data_transient
      t(2) = min(time(ln), max(time(1), year0 + relyr))
# else
      t(2) = min(time(ln), max(time(1), co2_yr))
# endif

      if (t(2) .le. time(1)) then
        d(2) = data(1)
      elseif (t(2) .ge. time(ln)) then
        d(2) = data(ln)
      else
        if (t(2) .gt. t(3)) then
          do n=2,ln
            if (time(n-1) .le. t(2) .and. time(n) .ge. t(2)) then
              t(1) = time(n-1)
              d(1) = data(n-1)
              t(3) = time(n)
              d(3) = data(n)
            endif
          enddo
        endif
        wt1 = 1.
        if (t(3) .ne. t(1)) wt1 = (t(3)-t(2))/(t(3)-t(1))
        wt1 = max(0., min(1., wt1))
        wt3 = 1. - wt1
        d(2) = d(1)*wt1 + d(3)*wt3
      endif

# if defined uvic_carbon_coupled
!     convert flux from Gt/year to g/cm2/s (surface area = 5.1e18cm^2)
      d(2) = d(2)/(5.1e18*yrlen*daylen)
#  if defined uvic_carbon_co2_2d
      flux(:,:,ico2) = flux(:,:,ico2) + d(2)
#  else
      co2flx = co2flx + d(2)
#  endif
# else
#  if defined uvic_carbon_co2_2d
      at(:,:,ico2) = d(2)
#  else
      co2ccn = d(2)
#  endif
# endif

#endif

      return
      end
