!====================== include file "npzd.h" =========================

!   variables for npzd model

!   ntnpzd  = total number of biology tracers
!   alpha   = initial slope P-I curve [(W/m^2)^(-1)/day]
!   kw      = light attenuation due to water [1/m]
!   kc      = light attenuation by phytoplankton [1/(m*mmol m-3)]
!   ki      = light attenuation through sea ice & snow
!   abio    = maximum growth rate parameter [1/day]
!   bbio    =
!   cbio    = [1/deg_C]
!   k1      = half saturation constant for N uptake [mmol m-3]
!   nup     = specific mortality rate (Phytoplankton) [day-1]
!   gamma1  = assimilation efficiency (zpk)
!   gbio    = maximum grazing rate [da-1y]
!   epsbio  = prey capture rate [(mmol m-3)-2 day-1]
!   nuz     = quadratic mortality (zpk)
!   gamma2  = excretion (zpk)
!   nud     = remineralization rate [day-1]
!   LFe     = Iron limitation
!   wd      = sinking speed of detritus [m day-1]
!   par     = fraction of photosythetically active radiation
!   dtnpzd  = time step of biology
!   redctn  = C/N Redfield ratio
!   rnpp    = rate of net primary production [mmol m-3 s-1]
!   rgraz   = rate of grazing [mmol m-3 s-1]
!   rmorp   = rate of mortality of phytoplankton [mmol m-3 s-1]
!   rmorz   = rate of mortality of zooplankton [mmol m-3 s-1]
!   rremi   = rate of remineralization [mmol m-3 s-1]
!   rexcr   = rate of excretion [mmol m-3 s-1]
!   rexpo   = rate of export through the bottom [mmol m-3 s-1]

      integer ntnpzd
      parameter (ntnpzd=4)

      integer npzdsi(nt)

      real alpha, kw, kc, ki, abio, bbio, cbio, k1, nup, gamma1, gbio
      real epsbio, nuz, gamma2, nud, LFe, wd, par, dtnpzd
      real redctn, rnpp, rgraz, rmorp, rmorz, rremi, rexcr, rexpo

      common /npzd/ alpha, kw, kc, ki, abio, bbio, cbio, k1, nup
      common /npzd/ gamma1, gbio, epsbio, nuz, gamma2, nud, LFe
      common /npzd/ wd, par, dtnpzd, redctn
# if defined uvic_npzd_out
      common /npzd/ rnpp(imt,km,jsmw:jemw), rgraz(imt,km,jsmw:jemw)
      common /npzd/ rmorp(imt,km,jsmw:jemw), rmorz(imt,km,jsmw:jemw)
      common /npzd/ rremi(imt,km,jsmw:jemw), rexcr(imt,km,jsmw:jemw)
      common /npzd/ rexpo(imt,km,jsmw:jemw)
# endif
