      subroutine vmixc (joff, js, je, is, ie)

!=======================================================================
!     set viscosity coefficient on bottom face of "u" cells
!     set diffusion coefficient on bottom face of "t" cells

!     input:
!       joff = offset relating "j" in the MW to latitude "jrow"
!       js   = starting row in the MW
!       je   = ending row in the MW
!       is   = starting longitude index in the MW
!       ie   = ending longitude index in the MW

!     based on code by: R. C. Pacanowski
!=======================================================================

#include "param.h"
#include "coord.h"
#if defined held_larichev
# include "hmixc.h"
#endif
#include "mw.h"
#include "switch.h"
#include "vmixc.h"
#if defined isopycmix || defined redi_diffusion
# include "isopyc.h"
#endif
#if defined constvmix && defined implicitvmix
      dimension temp(imt,km,jsmw:jmw)
#endif

!-----------------------------------------------------------------------
!     bail out if starting row exceeds ending row
!-----------------------------------------------------------------------

      if (js .gt. je) return

!-----------------------------------------------------------------------
!     limit the longitude and latitude indices
!-----------------------------------------------------------------------

      istrt = max(2,is)
      iend  = min(imt-1,ie)
      jstrt = max(2,js-1)
      jend  = je-1

#if defined constvmix

!-----------------------------------------------------------------------
!     constant vertical mixing coefficients
!-----------------------------------------------------------------------

      do j=jstrt,jend
        do i=istrt,iend
          do k=1,km
            visc_cbu(i,k,j) = kappa_m
# if defined bryan_lewis_vertical
            diff_cbt(i,k,j) = Ahv(k)
# else
            diff_cbt(i,k,j) = kappa_h
# endif
          enddo
        enddo
      enddo

# if defined implicitvmix
      do ks=1,2

!       find density

        call statec (t(1,1,1,1,taum1), t(1,1,1,2,taum1), temp(1,1,jsmw)
     &,                jstrt, jend, istrt, iend, ks)

!       set large diffusion coefficient between unstable layers
!       (note: viscosity coefficient is not limited but could be here)

        do j=jstrt,jend
          do k=ks,kmm1,2
            do i=istrt,iend
              if (temp(i,k,j) .gt. temp(i,k+1,j)) then
                diff_cbt(i,k,j) = diff_cbt_limit*tmask(i,k+1,j)
              endif
            enddo
          enddo
        enddo
      enddo
# endif
#endif

#if defined ppvmix

!-----------------------------------------------------------------------
!     for momentum and tracers based on the pacanowski & philander
!     richardson mixing scheme (JPO vol 11, #11, 1981).
!-----------------------------------------------------------------------

      call ppmix (joff, js, je, istrt, iend)
#endif

#if defined isopycmix || defined redi_diffusion

!-----------------------------------------------------------------------
!     Add K33 component to vertical diffusion coefficient
!-----------------------------------------------------------------------

      do j=jstrt,jend
        do i=istrt,iend
          do k=1,km
            diff_cbt(i,k,j) = diff_cbt(i,k,j) + K33(i,k,j)
          enddo
        enddo
      enddo
#endif

#if defined trace_indices
      write (stdout,'(2x,5(a,i4))')
     & "=> In vmixc: js=",js," je=",je," joff=",joff
     &," jstrt=",jstrt," jend=",jend
#endif
      return
      end
