!======================= include file "csbc.h" =========================

!     surface boundary conditions (S.B.C.)

!     numsbc    = total number of surface boundary conditions
!     indices and names set in UVic_ESCM.F:
!       itaux     = x component of wind stress (dynes cm-2)
!       itauy     = y component of wind stress (dynes cm-2)
!       iws       = surface wind speed (cm s-1)
!       iaca      = atmospheric coalbedo
!       isca      = surface coalbedo (%/100)
!       ihflx     = heat flux
!       isflx     = salt flux
!       isst      = ocean model SST (C)
!       isss      = ocean model SSS (PSU*0.001-0.035)
!       iwa       = surface wind angle (degrees)
!       iwxq      = x component of wind for moisture advection (cm s-1)
!       iwyq      = y component of wind for moisture advection (cm s-1)
!       iwxt      = x component of wind for temperature advection (cm s-1)
!       iwyt      = y component of wind for temperature advection (cm s-1)
!       iro       = surface runoff (g cm-2 s-1)
!       ipsw      = penitrating shortwave (cal cm-2 s-1)
!       isu       = x component of ocean first layer velocity (cm s-1)
!       isv       = y component of ocean first layer velocity (cm s-1)
!       igu       = x component of ocean second layer velocity (cm s-1)
!       igv       = y component of ocean second layer velocity (cm s-1)
!       issc      = sea surface concentration of carbon (umol cm-3)
!       icflx     = sea surface flux of carbon (umol cm-2 s-1)
!       issa      = sea surface concentration of alkalinity (umol cm-3)
!       issc14    = sea surface concentration of carbon 14 (umol cm-3)
!       ic14flx   = sea surface flux of carbon 14 (umol cm-2 s-1)
!       isso2     = sea surface concentration of oxygen (umol cm-3)
!       io2flx    = sea surface flux of carbon (umol cm-2 s-1)
!       isscfc11  = sea surface concentration of cfc11 (umol cm-3)
!       icfc11flx = sea surface flux of cfc11 (umol cm-2 s-1)
!       isscfc12  = sea surface concentration of cfc12 (umol cm-3)
!       icfc12flx = sea surface flux of cfc12 (umol cm-2 s-1)
!       iat       = surface air temperature (C)
!       irh       = surface relative humidity (%/100)
!       ipr       = precipitation as rain (g cm-2 s-1)
!       ips       = precipitation as snow (g cm-2 s-1)
!       iaws      = averaged surface wind speed (cm s-1)
!       iswr      = surface shortwave radiation (g s-3)
!       ilwr      = surface longwave radiation (g s-3)
!       isens     = surface sensible heat flux (g s-3)
!       ievap     = surface evaporation (g cm-2 s-1)
!       idtr      = diurnal temperature range (C)
!       inpp      = net primary production
!       isr       = soil resparation
!     mapsbc      = surface boundary conditions names
!     sbc         = surface boundary condition data.

!     ntspas      = the number of ocean time steps per atmosphere segment
!     ntspls      = the number of ocean time steps per land segment
!     ntspos      = the number of ocean time steps per ocean segment
!     dtatm       = atmosphere time step (s)
!     dtlnd       = land time step (s)
!     dtocn       = ocean time step (s)
!     dtatm       = atmosphere boundary condition averaging time (s)
!     dtlnd       = land boundary condition averaging time (s)
!     dtocn       = ocean boundary condition averaging time (s)
!     dampts      = time scale for damping surface tracers (days) to data
!     dampdz      = ocean level thickness for converting newtonian damping
!                   to a surface flux
!     land_map    = map with indices for coupling to land arrays

      integer numsbc
      parameter (numsbc = 10
#if defined uvic_embm_awind
     &                  + 1
#endif
#if defined uvic_embm_adv_q
     &                  + 2
#endif
#if defined uvic_embm_adv_t
     &                  + 2
#endif
#if defined shortwave
     &                  + 1
#endif
#if defined uvic_ice_evp
     &                  + 4
#endif
#if defined uvic_carbon
     &                  + 2
#endif
#if defined uvic_alk
     &                  + 1
#endif
#if defined uvic_c14
     &                  + 2
#endif
#if defined uvic_o2
     &                  + 2
#endif
#if defined uvic_cfc11
     &                  + 2
#endif
#if defined uvic_cfc12
     &                  + 2
#endif
#if defined uvic_mtlm
     &                  + 10
#endif
#if defined uvic_mtlm && defined uvic_carbon
     &                  + 2
#endif
     &                     )

      integer itaux, itauy, iws, iaca, isca, ihflx, isflx, isst, isss
      integer iwa, iwxq, iwyq, iwxt, iwyt, iro, ipsw, isu, isv, igu
      integer igv, issc, icflx, issa, iat, issc14, ic14flx, isso2
      integer io2flx, isscfc11, icfc11flx, isscfc12, icfc12flx, irh
      integer ipr, ips, iaws, iswr, ilwr, isens, ievap, idtr, inpp, isr

      common /csbc_i/ itaux, itauy, iws, iaca, isca, ihflx, isflx, isst
      common /csbc_i/ isss, iwa, iwxq, iwyq, iwxt, iwyt, iro, ipsw, isu
      common /csbc_i/ isv, igu, igv, issc, icflx, issa, iat, issc14
      common /csbc_i/ ic14flx, isso2, io2flx, isscfc11, icfc11flx
      common /csbc_i/ isscfc12, icfc12flx, irh, ipr, ips, iaws, iswr
      common /csbc_i/ ilwr, isens, ievap, idtr, inpp, isr

      character(20) :: mapsbc
      common /csbc_c/ mapsbc(numsbc)

      real sbc
      common /csbc_r/ sbc(imt,jmt,numsbc)

      integer ntspas, ntspls, ntspos
      common /csbc_i/ ntspas, ntspls, ntspos

      real dtatm, dtlnd, dtocn, atatm, atlnd, atocn
      common /csbc_r/ dtlnd, dtatm, dtocn, atatm, atlnd, atocn

      real dampts, dampdz
      common /csbc_r/ dampts(nt), dampdz(nt)
#if defined llnl_plume
      common /csbc_r/ subflux(imt,jmt,nt), subz(imt,jmt)
#endif
#if defined uvic_mtlm
      integer land_map

      common /csbc_i/ land_map(imt,jmt)
#endif
