!====================== include file "npzd.h" =========================

!   variables for npzd model

!   alpha   = initial slope P-I curve [(W/m^2)^(-1)/day]
!   kw      = light attenuation due to water [1/m]
!   kc      = light attenuation by phytoplankton [1/(m*mmol m-3)]
!   ki      = light attenuation through sea ice & snow
!   abio    = maximum growth rate parameter [1/day]
!   bbio    =
!   cbio    = [1/deg_C]
!   k1      = half saturation constant for N uptake [mmol m-3]
!   nup     = specific mortality rate (Phytoplankton) [day-1]
!   gamma1  = assimilation efficiency (zpk)
!   gbio    = maximum grazing rate [da-1y]
!   epsbio  = prey capture rate [(mmol m-3)-2 day-1]
!   nuz     = quadratic mortality (zpk)
!   gamma2  = excretion (zpk)
!   nud0    = remineralization rate [day-1]
!   LFe     = Iron limitation
!   wd      = sinking speed of detritus [m day-1]
!   par     = fraction of photosythetically active radiation
!   dtnpzd  = time step of biology
!   redctn  = C/N Redfield ratio
!   redptn  = P/N Redfield ratio
!   phyt    = concentration of nitrate in phytoplankton [mmol m-3]
!   zoop    = concentration of nitrate in zooplankton [mmol m-3]
!   detr    = concentration of nitrate in detritus [mmol m-3]
!   rnpp    = rate of net primary production [mmol m-3 s-1]
!   rgraz   = rate of grazing [mmol m-3 s-1]
!   rmorp   = rate of mortality of phytoplankton [mmol m-3 s-1]
!   rmorz   = rate of mortality of zooplankton [mmol m-3 s-1]
!   rremi   = rate of remineralization [mmol m-3 s-1]
!   rexcr   = rate of excretion [mmol m-3 s-1]
!   rexpo   = rate of export through the bottom [mmol m-3 s-1]
!   trcmin  = minimum tracer for flux calculations
!   rcak    = array used in calculating calcite remineralization
!   rcab    = array used in calculating bottom calcite remineralization

      integer ntnpzd
      parameter (ntnpzd=4 !nutrients,phytoplankton,zooplankon,detritus
#if defined uvic_nitrogen
     &                 +2 !NO3,N2-fixers (diazotraphs)
#endif
     &                    )

      real alpha, kw, kc, ki, abio, bbio, cbio, k1, nup, gamma1, gbio
      real epsbio, nuz, gamma2, nud0, LFe, wd, par, dtnpzd, redctn
      real phyt, zoop, detr, rnpp, rgraz, rmorp, rmorpt, rmorz, rremi
      real rexcr, rexpo, rainr, dcaco3, trcmin, rcak, rcab, nupt0, wd0
      real redptn, k1p
#if defined uvic_nitrogen
      real jdiar, diaz, rnpp_D, rgraz_D, rmorp_D
#endif
#if defined uvic_o2
      real redotn, redotp
#endif

      common /npzd_r/ alpha, kw, kc, ki, abio, bbio, cbio, k1, nup
      common /npzd_r/ gamma1, gbio, epsbio, nuz, gamma2, nud0, LFe
      common /npzd_r/ wd(km), par, dtnpzd, redctn, rainr, dcaco3
      common /npzd_r/ trcmin, rcak(km), rcab(km), nupt0, wd0
      common /npzd_r/ k1p, redptn
#if defined uvic_o2
      common/npzd_r/ redotn, redotp
#endif
#if defined uvic_nitrogen
      common/npzd_r/ jdiar
#endif
#if defined uvic_npzd_simple
      common /npzd_r/ phyt(imt,kpzd,jmt,2)
      common /npzd_r/ zoop(imt,kpzd,jmt,2)
      common /npzd_r/ detr(imt,kpzd,jmt,2)
# if defined uvic_nitrogen
      common /npzd_r/ diaz(imt,kpzd,jmt,2)
# endif
#endif
#if defined uvic_npzd_out
      common /npzd_r/ rnpp(imt,kpzd,jsmw:jemw)
      common /npzd_r/ rgraz(imt,kpzd,jsmw:jemw)
      common /npzd_r/ rmorp(imt,kpzd,jsmw:jemw)
      common /npzd_r/ rmorpt(imt,kpzd,jsmw:jemw)
      common /npzd_r/ rmorz(imt,kpzd,jsmw:jemw)
      common /npzd_r/ rremi(imt,kpzd,jsmw:jemw)
      common /npzd_r/ rexcr(imt,kpzd,jsmw:jemw)
      common /npzd_r/ rexpo(imt,kpzd,jsmw:jemw)
# if defined uvic_nitrogen
      common /npzd_r/ rnpp_D(imt,kpzd,jsmw:jemw)
      common /npzd_r/ rgraz_D(imt,kpzd,jsmw:jemw)
      common /npzd_r/ rmorp_D(imt,kpzd,jsmw:jemw)
# endif
#endif
