      subroutine eoyr (is, ie, js, je)
!=======================================================================
!     things to do at the end of a year

!     input:
!       is, ie, js, je = starting and ending indicies for i and j

!     based on code by: M. Eby
!=======================================================================
#if defined uvic_embm

      implicit none

# include "param.h"
# include "calendar.h"
# include "csbc.h"
# include "levind.h"
# include "atm.h"
# include "coord.h"
# include "grdvar.h"
# if defined uvic_ice
#  include "ice.h"
# endif
# if defined uvic_mtlm
#  include "mtlm.h"
# endif
# include "cembm.h"
# include "iounit.h"
# include "scalar.h"
# include "switch.h"
# include "tmngr.h"

      character(120) :: fname, new_file_name

      integer i, ie, is, iou, j, je, js, L, ib(10), ic(10)

      logical exists, inqvardef

      real wt

# if defined uvic_embm_orbit_transient

        orbit_yr = year0 + relyr
        call berger (orbit_yr)
# endif
# if defined uvic_embm_icedata_transient

!     recalculate land masks to be consistient with aicel
      fname = new_file_name ("tmsk.nc")
      inquire (file=trim(fname), exist=exists)
      if (.not. exists) then
        print*, "Warning => ", trim(fname), " does not exist."
      else
        call openfile (fname, iou)
        exists = inqvardef('tmsk', iou)
        ib(:) = 1
        ic(:) = imt
        ic(2) = jmt
        if (exists) call getvara ('tmsk', iou, imt*jmt, ib, ic, tmsk
     &,   c1, c0)
        call closefile (iou)
      endif
      if (.not. exists) then
        tmsk(:,:) = 0.
        do j=1,jmtm1
          do i=1,imtm1
            if (kmt(i,j) .gt. 0.) tmsk(i,j) = 1.
          enddo
        enddo
      endif

      call icedata

      do j=1,jmtm1
        do i=1,imtm1
          if (aicel(i,j,2) .ge. 0.5) tmsk(i,j) = 0.
        enddo
      enddo

      call embmbc (tmsk)

      do j=2,jmtm1
        do i=2,imtm1
          umsk(i,j) = min (tmsk(i,j), tmsk(i+1,j), tmsk(i,j+1)
     &,                    tmsk(i+1,j+1))
        enddo
      enddo
      call embmbc (umsk)
!     remove isolated bays
      do j=2,jmtm1
        do i=2,imtm1
          tmsk(i,j) = max (umsk(i,j), umsk(i-1,j), umsk(i,j-1)
     &,                    umsk(i-1,j-1))
        enddo
      enddo
      call embmbc (tmsk)

!     recalculate rivers to be consistient with land masks
      call init_discharge
#  if defined uvic_mtlm

!     set flag to recalculate land index
      NEW_LAND = .true.
#  endif
# endif
# if defined uvic_embm_running_average || defined uvic_embm_astress || defined uvic_embm_calc_diffq

!     make new annual and running average
      call embmbc (atbar)
      if (totaltime .ge. yrlen*daylen - dtatm*0.5) then
        wt = 1.
        do j=js,je
          do i=is,ie
            rtbar(i,j) = ((1.-wt)*rtbar(i,j) + wt*atbar(i,j)/totaltime)
            atbar(i,j) = 0.0
          enddo
        enddo
      endif
      totaltime = 0.0
#  if defined uvic_embm_astress

      call calc_astress (is, ie, js, je)
#  endif
#  if defined uvic_embm_calc_diffq

      do j=2,jmtm1
        do i=2,imtm1
          dn(i,j,2) = abs((rtbar(i,j+1) - rtbar(i,j))*dyur(j)*1.e17)
          de(i,j,2) = abs((rtbar(i+1,j) - rtbar(i,j))*dxur(j)
     &                *cstr(j)*1.e17)
        enddo
      enddo
      dn(:,jmtm1,2) = dn(:,jmtm2,2)
      call embmbc (dn(1,1,2))
      call embmbc (de(1,1,2))
#  endif
# endif
#endif

      return
      end
