      subroutine albedo
!=======================================================================
!     calculate atmospheric albedo

!     calculates an atmospheric albedo based on planetary and surface
!     fields. the zonal average atmospheric (cloud portion) albedo may
!     be distributed in proportion to the local precipitation. the
!     amount of redistribution depends on pcfactor (correlation factor).
!     redistribution is reduced (as a cosine) at high latitudes.

!     based on code by: D. Matthews and M. Eby
!=======================================================================
#if defined uvic_embm

      implicit none

# include "param.h"
# include "csbc.h"
# include "ctdbc.h"
# include "tmngr.h"
# include "switch.h"
# include "atm.h"
# include "cembm.h"
# include "ndcon.h"
# include "grdvar.h"
# include "coord.h"
# include "calendar.h"

      integer i, in, ip, j, jz, n

      real alb, area, an, ap, c_alb, fp, p, p_alb, sj, wn, wp, wz
      real alb0(12), alb1(12), alb2(12), a0, a1, a2
      real a_alb_z(jmz), p_z(jmz), p_max_z(jmz), fp_z(jmz)

      data alb0 / 0.667, 0.667, 0.667, 0.680, 0.687, 0.687
     &,           0.687, 0.693, 0.693, 0.687, 0.673, 0.667/
      data alb1 /-0.080,-0.080,-0.040, 0.000, 0.034, 0.048
     &,           0.048, 0.045, 0.019,-0.020,-0.038,-0.080/
      data alb2 /-0.267,-0.267,-0.267,-0.240,-0.227,-0.227
     &,          -0.227,-0.213,-0.213,-0.227,-0.253,-0.267/

      do jz=1,jmz
        a_alb_z(jz) = c0
        p_z(jz)     = c0
        p_max_z(jz) = c0
        fp_z(jz)    = c0
      enddo

# if defined time_varying_sbc_data
!     use timing from first time varying sbc for albedo
      n = 1
      if (ntdrec(n) .ne. 12) then
        print*, '=>Error: only set up for monthly varying albedo'
        stop '=>albedo1: in atmos.F'
      endif
      ip = iprevd(n)
      in = inextd(n)
      wp = wprev(n)
# else
      a0 = 0.0
      a1 = 0.0
      a2 = 0.0
      do n=1,12
        a0 = a0 + alb0(n)*daypm(n)
        a1 = a1 + alb1(n)*daypm(n)
        a2 = a2 + alb2(n)*daypm(n)
      enddo
      a0 = a0/yrlen
      a1 = a1/yrlen
      a2 = a2/yrlen
      wp = c1
# endif
      wn = c1 - wp

      do jz=2,jmzm1
!       calculate planetary albedo from data
        sj = sin(yz(jz)/radian)
# if defined time_varying_sbc_data
        ap = alb0(ip) + alb1(ip)*sj + alb2(ip)*(c3*sj**2 - c1)*p5
        an = alb0(in) + alb1(in)*sj + alb2(in)*(c3*sj**2 - c1)*p5
# else
        ap = a0 + a1*sj + a2*(c3*sj**2 - c1)*p5
        an = ap
# endif
        p_alb = (c1 - (wp*ap + wn*an))*0.99
        if (p_alb .le. s_alb_z(jz)*pass) then
          print*, '=>Error: surface albedo exceeds planetary'
          stop '=>albedo2: in atmos.F'
        endif
!       calculate atmospheric albedo from surface and planetary
        a_alb_z(jz) = (p_alb - s_alb_z(jz)*pass)/(c1 - s_alb_z(jz)*pass)
      enddo

      if (pcfactor .gt. 0.001) then

!       if pcfactor > 0 redistribute albedo with precipitation
        do j=1,jmt
          do i=1,imt
            area = dxt(i)*dyt(j)*cst(j)
            jz = int(wt_zonal(i,j))
            wz = wt_zonal(i,j) - jz
            p_z(jz) = p_z(jz) + (c1-wz)*precip(i,j)*area
            p_z(jz+1) = p_z(jz+1) + wz*precip(i,j)*area
            p_max_z(jz) = max(p_max_z(jz), (c1-wz)*precip(i,j))
            p_max_z(jz+1) = max(p_max_z(jz+1), wz*precip(i,j))
          enddo
        enddo

!       calculate zonal average and redistribution function
        do jz=2,jmzm1
          p_z(jz) = p_z(jz)/area_z(jz) + epsln
          if (p_max_z(jz) .ne. p_z(jz)) then
            alb = min(a_alb_z(jz)*(c1 + pcfactor),0.9 - cs_alb)
            fp_z(jz) = (alb/(a_alb_z(jz))-c1)/((p_max_z(jz)/p_z(jz))-c1)
            fp_z(jz) = pcfactor*cos(yz(jz)/radian)*min(fp_z(jz), c1)
          endif
        enddo

!       calculate redistributed atmospheric albedo
        do j=1,jmt
          do i=1,imt
            jz = int(wt_zonal(i,j))
            wz = wt_zonal(i,j) - jz
            c_alb = ((c1-wz)*a_alb_z(jz) + wz*a_alb_z(jz+1)) - cs_alb
            p = (c1-wz)*p_z(jz) + wz*p_z(jz+1)
            fp = (c1-wz)*fp_z(jz) + wz*fp_z(jz+1)
            if (p .gt. c0 .and. fp .gt. c0) then
!             distribute cloud albedo with precipitation
              c_alb = c_alb*(c1 - fp + fp*precip(i,j)/p)
            endif
            a_calb(i,j) = c1 - (c_alb + cs_alb)
          enddo
        enddo

      else

!       if pcfactor = 0, just interpolate from zonal average
        do j=1,jmt
          do i=1,imt
            jz = int(wt_zonal(i,j))
            wz = wt_zonal(i,j) - jz
            a_calb(i,j) = c1 - ((c1-wz)*a_alb_z(jz)+wz*a_alb_z(jz+1))
          enddo
        enddo

      endif

      call embmbc (a_calb)

#endif
      return
      end
