      subroutine vmixc (joff, js, je, is, ie)

!=======================================================================
!     set viscosity coefficient on bottom face of "u" cells
!     set diffusion coefficient on bottom face of "t" cells

!     input:
!       joff = offset relating "j" in the MW to latitude "jrow"
!       js   = starting row in the MW
!       je   = ending row in the MW
!       is   = starting longitude index in the MW
!       ie   = ending longitude index in the MW

!     based on code by: R. C. Pacanowski
!=======================================================================

#include "param.h"
#include "coord.h"
#if defined held_larichev
# include "hmixc.h"
#endif
#include "mw.h"
#include "switch.h"
#include "vmixc.h"
#if defined isopycmix || defined redi_diffusion
# include "isopyc.h"
# if defined uvic_tidal_kv
#  include "tidal_kv.h"
#  include "diag.h"
#  include "grdvar.h"
#  include "levind.h"
# endif
#endif
#if defined uvic_kv_out
# include "timeavgs.h"
#endif
#if defined constvmix && defined implicitvmix
      dimension temp(imt,km,jsmw:jmw)
#endif

!-----------------------------------------------------------------------
!     bail out if starting row exceeds ending row
!-----------------------------------------------------------------------

      if (js .gt. je) return

!-----------------------------------------------------------------------
!     limit the longitude and latitude indices
!-----------------------------------------------------------------------

      istrt = max(2,is)
      iend  = min(imt-1,ie)
      jstrt = max(2,js-1)
      jend  = je-1

#if defined constvmix

!-----------------------------------------------------------------------
!     constant vertical mixing coefficients
!-----------------------------------------------------------------------

      do j=jstrt,jend
        do i=istrt,iend
          do k=1,km
# if !defined uvic_tidal_kv_momentum
            visc_cbu(i,k,j) = kappa_m
# endif
# if defined bryan_lewis_vertical && !defined uvic_tidal_kv
            diff_cbt(i,k,j) = Ahv(k)
# elif defined uvic_tidal_kv

!           calculate N^2 = -g/rho drhodz on bottom of cell face
!           (where K33 and diff_cbt = kappa_h are defined). Note that
!           N2 is not guaranteed to be positive. If instability occurs,
!           convective adjustment will eliminate it.
!           drodzb is defined in isopyc.h

!           ZN2 is defined on T-cell bottom (zw pt), where we want it.
            ZN2 = -gravrho0r*drodzb(i,k,j,0)
#  if defined uvic_tidal_kv_iso

!           internally generated idealized dissipation profile,
!           depending on N^2

!           diss      = 2.0e-3 ! 2 mW/m^2, typical value from Jayne and
!                       St. Laurent, 2000. global integrated value,
!                       diss*area is approx 1TW (10^2 W)
!           eps       = (diss*area)/(rho0*volume)
!           kappa     = gamma*eps/N2
!           zkappa_iso [cm^2 s^-1]

            eps = 2.0e-3*1.0e-4*1000.*tcella(1)/(tcellv*rho0)

            zkappa_iso = 0.0
            if (ZN2 .ne. 0) zkappa_iso = 1.e4*0.2*eps/ZN2
#  endif
#  if defined uvic_tidal_kv_bottom

!           height above bottom
            if (kmt(i,j+joff) .ne. 0.0) then
              hab = zw(k) - zw(kmt(i,j+joff) - 1)
            else
              hab = 0.0
            endif

            if (Zn2 .ne. 0.0) then
              zkappa_bottom = ogamma*edr(i,j+joff)*exp(hab*zetar)/
     &                        (ZN2*(1-exp(-zetar*zw(kmt(i,j+joff)))))
            else
              zkappa_bottom = 0.0
            endif
#  endif

#  if defined bryan_lewis_vertical
#   if defined uvic_tidal_kv_bottom && defined uvic_tidal_kv_iso
            zkappa = 0.33*zkappa_bottom + 0.66*zkappa_iso + Ahv(k)
#   elif defined uvic_tidal_kv_bottom && !defined uvic_tidal_kv_iso
            zkappa = 0.33*zkappa_bottom  + Ahv(k)
#   elif !defined uvic_tidal_kv_bottom && defined uvic_tidal_kv_iso
            zkappa = zkappa_iso + Ahv(k)
#   else
            write (stdout,'(/,(1x,a))')
     &        '==> Error (vmixc): uvic_tidal_kv defined, but'
     &,       ' uvic_tidal_kv_bottom or uvic_tidal_kv_iso are not'
        stop 'vmixc'
#   endif

!           limit kv values that are negative (resulting from unstable
!           stratification)

!           clip
            if (zkappa .gt. 100) zkappa = 100.
!           convecting, dont enhance mixing
            if (zkappa .lt. Ahv(k)) zkappa = Ahv(k)
#  else
#   if defined uvic_tidal_kv_bottom && defined uvic_tidal_kv_iso
            zkappa = 0.33*zkappa_bottom + 0.66*zkappa_iso + kappa_h
#   elif defined uvic_tidal_kv_bottom && !defined uvic_tidal_kv_iso
            zkappa = 0.33*zkappa_bottom  + kappa_h
#   elif !defined uvic_tidal_kv_bottom && defined uvic_tidal_kv_iso
            zkappa = zkappa_iso + kappa_h
#   else
            write (stdout,'(/,(1x,a))')
     &        '==> Error (vmixc): uvic_tidal_kv defined, but'
     &,       ' uvic_tidal_kv_bottom or uvic_tidal_kv_iso are not'
        stop 'vmixc'
#   endif

!           limit kv values that are negative (resulting from unstable
!           stratification)

!           clip
            if (zkappa .gt. 100) zkappa = 100.
!           convecting, dont enhance mixing
            if (zkappa .lt. kappa_h) zkappa = kappa_h
#  endif

!           set higher value of kappa_v in Arctic where Peclet number
!           violations are causing spurious cold water mass formation

            if (tlat(i,j+joff) .gt. 73.) zkappa = 1.0

            diff_cbt(i,k,j) = zkappa

#  if defined uvic_tidal_kv_momentum
            visc_cbu(i,k,j) = 10.*zkappa
#  endif
# else
            diff_cbt(i,k,j) = kappa_h
# endif
          enddo
        enddo
      enddo

# if defined implicitvmix
      do ks=1,2

!       find density

        call statec (t(1,1,1,1,taum1), t(1,1,1,2,taum1), temp(1,1,jsmw)
     &,                jstrt, jend, istrt, iend, ks)

!       set large diffusion coefficient between unstable layers
!       (note: viscosity coefficient is not limited but could be here)

        do j=jstrt,jend
          do k=ks,kmm1,2
            do i=istrt,iend
              if (temp(i,k,j) .gt. temp(i,k+1,j)) then
                diff_cbt(i,k,j) = diff_cbt_limit*tmask(i,k+1,j)
              endif
            enddo
          enddo
        enddo
      enddo
# endif
#endif

#if defined ppvmix

!-----------------------------------------------------------------------
!     for momentum and tracers based on the pacanowski & philander
!     richardson mixing scheme (JPO vol 11, #11, 1981).
!-----------------------------------------------------------------------

      call ppmix (joff, js, je, istrt, iend)
#endif
#if defined uvic_kv_out
!-----------------------------------------------------------------------
!     accumulate time average diapycnal (without K33) diffusivity
!-----------------------------------------------------------------------

      if (timavgperts .and. .not. euler2) then
        do j=jstrt,jend
          jrow = j + joff
          do k=1,km
            do i=istrt,iend
              ta_diff_cbt(i,k,jrow) = ta_diff_cbt(i,k,jrow) +
     &                              diff_cbt(i,k,j)
            enddo
          enddo
        enddo
      endif
#endif
#if defined isopycmix || defined redi_diffusion

!-----------------------------------------------------------------------
!     Add K33 component to vertical diffusion coefficient
!-----------------------------------------------------------------------

      do j=jstrt,jend
        do i=istrt,iend
          do k=1,km
            diff_cbt(i,k,j) = diff_cbt(i,k,j) + K33(i,k,j)
          enddo
        enddo
      enddo
#endif

#if defined trace_indices
      write (stdout,'(2x,5(a,i4))')
     & "=> In vmixc: js=",js," je=",je," joff=",joff
     &," jstrt=",jstrt," jend=",jend
#endif
      return
      end
