! source file: /usr/local/models/UVic_ESCM/2.8/source/common/coord.h
!======================= include file "coord.h" ========================

!                    model grid point coordinates

!     grid definition:

!     the model uses a staggered arakawa "b" grid which is setup and
!     generated by the "grids.F" module.

!     xt(i)   = longitude of the ith "t" point in degrees.   i=1..imt
!     xu(i)   = longitude of the ith "u,v" point in degrees. i=1..imt
!     yt(j)   = latitude of the jth "t" point in degrees.    j=1..jmt
!     yu(j)   = latitude of the jth "u,v" point in degrees.  j=1..jmt
!     zt(k)   = distance from surface down to centre of level k (in cm)
!               (for depth of "t" and "u,v" grid points: k=1,km)
!     zw(k)   = distance from surface down to bottom of level k (in cm)
!               (for depth of "t" and "u,v" grid points: k=1,km)
!     dxtdeg  = widths for "t" grid cells (degrees)
!     dytdeg  = heights for "t" grid cells (degrees)
!     dxudeg  = widths for "u" grid cells (degrees)
!     dyudeg  = heights for "u" grid cells (degrees)
!     dzt(k)  = vertical resolution of "t" and "u" grid cells (in cm)
!     dzw(k)  = vertical resolution of "w" grid cells (in cm)

!     "i" increases in an eastward direction, "j" increases in a
!     northward direction, and "k" increases downward.

      real  xt, yt, xu, yu, zw, zt
      real dxtdeg, dytdeg, dzt
      real dxudeg, dyudeg, dzw

      common /coord/ xt(imt), yt(jmt), xu(imt), yu(jmt), zw(km), zt(km)
      common /coord/ dxtdeg(imt), dytdeg(jmt), dzt(km)
      common /coord/ dxudeg(imt), dyudeg(jmt), dzw(0:km)
