! source file: /usr/local/models/UVic_ESCM/2.8/source/common/def_snap.F
      subroutine def_snap
!=======================================================================
!     defines snap files for UVic_ESCM

!     based on code by: M. Eby
!=======================================================================

      character(120) :: fname

      call def_snap_embm (fname)

      call def_snap_mom (fname)

      return
      end

      subroutine def_snap_embm (fname)
!=======================================================================
!     defines snap files for the embm

!     output:
!       fname = file name

!     based on code by: M. Eby
!=======================================================================

      implicit none

      include "size.h"
      include "coord.h"
      include "atm.h"
      include "ice.h"
      include "iounit.h"
      include "tmngr.h"

      character(120) :: fname, file_stamp, name, new_file_name
      integer iou, ntrec
      save name
      data name /' '/

      if (name .eq. ' ') then
        name = file_stamp ('snap_embm',stamp,'.nc')
        name = new_file_name (name)
        call opennext (name, relyr, ntrec, iou)
        call closefile (iou)
        if (ntrec .gt. 1) then
          call opennew (name, iou)
          call closefile (iou)
        endif
        call embm_snap_def (name, imt, jmt, nat, ncat, xt, yt, timunit
     &,                     expnam, runstamp, mapat)
      endif
      fname = name

      return
      end

      subroutine def_snap_mom (fname)
!=======================================================================
!     defines snap files for the mom

!     output:
!       fname = file name

!     based on code by: M. Eby
!=======================================================================

!      implicit none

      include "param.h"
      include "coord.h"
      include "iounit.h"
      include "mw.h"
      include "tmngr.h"

      character(120) :: fname, file_stamp, name, new_file_name
      integer iou, ntrec
      save name
      data name /' '/

      if (name .eq. ' ') then
        name = file_stamp ('snap_mom',stamp,'.nc')
        name = new_file_name (name)
        call opennext (name, relyr, ntrec, iou)
        call closefile (iou)
        if (ntrec .gt. 1) then
          call opennew (name, iou)
          call closefile (iou)
        endif
        call mom_snap_def (name, imt, jmt, km, nt, kpzd, xt, yt, timunit
     &,                    expnam, runstamp, mapt)
      endif
      fname = name

      return
      end

