! source file: /usr/local/models/UVic_ESCM/2.8/source/common/def_tavg.F
      subroutine def_tavg
!=======================================================================
!     defines tavg files for UVic_ESCM

!     based on code by: M. Eby
!=======================================================================

      character(120) :: fname

      call def_tavg_embm (fname)

      call def_tavg_mtlm (fname)

      call def_tavg_mom (fname)

      return
      end

      subroutine def_tavg_embm (fname)
!=======================================================================
!     defines tavg files for the embm

!     output:
!       fname = file name

!     based on code by: M. Eby
!=======================================================================

      implicit none

      include "size.h"
      include "coord.h"
      include "atm.h"
      include "ice.h"
      include "iounit.h"
      include "tmngr.h"

      character(120) :: fname, file_stamp, name, new_file_name
      integer iou, ntrec
      save name
      data name /' '/

      if (name .eq. ' ') then
        name = file_stamp ('tavg_embm',stamp,'.nc')
        name = new_file_name (name)
        call opennext (name, relyr, ntrec, iou)
        call closefile (iou)
        if (ntrec .gt. 1) then
          call opennew (name, iou)
          call closefile (iou)
        endif
        call embm_snap_def (name, imt, jmt, nat, ncat, xt, yt, timunit
     &,                     expnam, runstamp, mapat)
      endif
      fname = name

      return
      end

      subroutine def_tavg_mtlm (fname)
!=======================================================================
!     defines tavg files for the mtlm

!     output:
!       fname = file name

!     based on code by: M. Eby
!=======================================================================

      implicit none

      include "size.h"
      include "coord.h"
      include "iounit.h"
      include "tmngr.h"

      character(120) :: fname, file_stamp, name, new_file_name
      integer iou, ntrec
      save name
      data name /' '/

      if (name .eq. ' ') then
        name = file_stamp ('tavg_mtlm',stamp,'.nc')
        name = new_file_name (name)
        call opennext (name, relyr, ntrec, iou)
        call closefile (iou)
        if (ntrec .gt. 1) then
          call opennew (name, iou)
          call closefile (iou)
        endif
        call mtlm_snap_def (name, imt, jmt, NPFT, NTYPE, xt, yt
     &,                     timunit, expnam, runstamp)
      endif
      fname = name

      return
      end

      subroutine def_tavg_mom (fname)
!=======================================================================
!     defines tavg files for the mom

!     output:
!       fname = file name

!     based on code by: M. Eby
!=======================================================================

!      implicit none

      include "param.h"
      include "coord.h"
      include "iounit.h"
      include "mw.h"
      include "tmngr.h"

      character(120) :: fname, file_stamp, name, new_file_name
      integer iou, ntrec
      save name
      data name /' '/

      if (name .eq. ' ') then
        name = file_stamp ('tavg_mom',stamp,'.nc')
        name = new_file_name (name)
        call opennext (name, relyr, ntrec, iou)
        call closefile (iou)
        if (ntrec .gt. 1) then
          call opennew (name, iou)
          call closefile (iou)
        endif
        call mom_snap_def (name, imt, jmt, km, nt, kpzd, xt, yt, timunit
     &,                    expnam, runstamp, mapt)
      endif
      fname = name

      return
      end

