! source file: /usr/local/models/UVic_ESCM/2.8/source/common/def_tsi.F
      subroutine def_tsi
!=======================================================================
!     defines tsi files for UVic_ESCM

!     based on code by: M. Eby
!=======================================================================

      character(120) :: fname

      call def_tsi_embm (fname)

      call def_tsi_mtlm (fname)

      call def_tsi_mom (fname)

      return
      end

      subroutine def_tsi_embm (fname)
!=======================================================================
!     defines tsi files for the embm

!     output:
!       fname = file name

!     based on code by: M. Eby
!=======================================================================

      implicit none

      include "iounit.h"
      include "tmngr.h"

      character(120) :: fname, file_stamp, name, new_file_name
      integer iou, ntrec
      save name
      data name /' '/

      if (name .eq. ' ') then
        name = file_stamp ('tsi_embm',stamp,'.nc')
        name = new_file_name (name)
        call opennext (name, relyr, ntrec, iou)
        call closefile (iou)
        if (ntrec .gt. 1) then
          call opennew (name, iou)
          call closefile (iou)
        endif
        call embm_tsi_def (name, timunit, expnam, runstamp)
      endif
      fname = name

      return
      end

      subroutine def_tsi_mtlm (fname)
!=======================================================================
!     defines tsi files for the mtlm

!     output:
!       fname = file name

!     based on code by: M. Eby
!=======================================================================

      implicit none

      include "iounit.h"
      include "tmngr.h"

      character(120) :: fname, file_stamp, name, new_file_name
      integer iou, ntrec
      save name
      data name /' '/

      if (name .eq. ' ') then
        name = file_stamp ('tsi_mtlm',stamp,'.nc')
        name = new_file_name (name)
        call opennext (name, relyr, ntrec, iou)
        call closefile (iou)
        if (ntrec .gt. 1) then
          call opennew (name, iou)
          call closefile (iou)
        endif
        call mtlm_tsi_def (name, timunit, expnam, runstamp)
      endif
      fname = name

      return
      end

      subroutine def_tsi_mom (fname)
!=======================================================================
!     defines tsi files for the mom

!     output:
!       fname = file name

!     based on code by: M. Eby
!=======================================================================

!      implicit none

      include "iounit.h"
      include "tmngr.h"

      character(120) :: fname, file_stamp, name, new_file_name
      integer iou, ntrec
      save name
      data name /' '/

      if (name .eq. ' ') then
        name = file_stamp ('tsi_mom',stamp,'.nc')
        name = new_file_name (name)
        call opennext (name, relyr, ntrec, iou)
        call closefile (iou)
        if (ntrec .gt. 1) then
          call opennew (name, iou)
          call closefile (iou)
        endif
        call mom_tsi_def (name, timunit, expnam, runstamp)
      endif
      fname = name

      return
      end

