! source file: /usr/local/models/UVic_ESCM/2.8/source/mom/mom_tsi.F
      subroutine mom_tsi_def (fname, timunit, expnam, runstamp)
!=======================================================================
!     output routine for ocean time step integrals

!   inputs:
!     fname      = file name
!     timunit    = time unit
!     expnam     = experiment name
!     runstamp   = run stamp

!     based on code by: M. Eby
!=======================================================================

      implicit none

      character(*) :: fname, timunit, expnam, runstamp

      integer id(1), id_time, iou, ntrec

      real c0, c1, c100, c400, c1e3, c1e6, c1e20

      c0 = 0.
      c1 = 1.
      c100 = 100.
      c400 = 400.
      c1e3 = 1.e3
      c1e6 = 1.e6
      c1e20 = 1.e20

!-----------------------------------------------------------------------
!     open file
!-----------------------------------------------------------------------
      call openfile (fname, iou)

!-----------------------------------------------------------------------
!     start definitions
!-----------------------------------------------------------------------
      call redef (iou)

!-----------------------------------------------------------------------
!     write global atributes
!-----------------------------------------------------------------------
      call putatttext (iou, 'global', 'Conventions', 'CF-1.0')
      call putatttext (iou, 'global', 'experiment_name', expnam)
      call putatttext (iou, 'global', 'run_stamp', runstamp)
      call putatttext (iou, 'global', 'time_unit', timunit)

!-----------------------------------------------------------------------
!     define dimensions
!-----------------------------------------------------------------------
      call defdim ('time', iou, 0, id_time)
      id = id_time

!-----------------------------------------------------------------------
!     define 1d data (t)
!-----------------------------------------------------------------------
      call defvar ('time', iou, 1, id, c0, c0, 'T', 'D'
     &, 'time since initial condition', 'time', trim(timunit))
      call defvar ('year', iou, 1, id, c0, c0, ' ', 'F'
     &, 'year', ' ',' ')
      call defvar ('month', iou, 1, id, c0, c0, ' ', 'F'
     &, 'month', ' ',' ')
      call defvar ('day', iou, 1, id, c0, c0, ' ', 'F'
     &, 'day', ' ',' ')
      call defvar ('hour', iou, 1, id, c0, c0, ' ', 'F'
     &, 'hour', ' ',' ')
      call defvar ('minute', iou, 1, id, c0, c0, ' ', 'F'
     &, 'minute', ' ',' ')
      call defvar ('second', iou, 1, id, c0, c0, ' ', 'F'
     &, 'second', ' ',' ')
      call defvar ('period', iou, 1, id, c0, c0, ' ', 'F'
     &, 'averaging period', ' ','days')
      call defvar ('ke', iou, 1, id, c0, c1e6, ' ', 'F'
     &, 'Kinetic energy per unit volume', ' ', 'J m-3')
      call defvar ('tbar', iou, 1, id, c100, c400, ' ', 'F'
     &, 'Global average T', ' ', 'K')
      call defvar ('sbar', iou, 1, id, c0, c100, ' ', 'F'
     &, 'Global average S', ' ', '1e-3')
      call defvar ('tvar', iou, 1, id, c0, c1e20, ' ', 'F'
     &, 'Variance of T', ' ', 'K2')
      call defvar ('svar', iou, 1, id, c0, c1e20, ' ', 'F'
     &, 'Variance of S', ' ', '1e-6')
      call defvar ('abs_chg_t', iou, 1, id, c0, c1e20, ' '
     &, 'F', '|dT/dt|', ' ', 'K s-1')
      call defvar ('abs_chg_s', iou, 1, id, c0, c1e20, ' '
     &, 'F', '|dS/dt|', ' ', '1e-3 s-1')
      call defvar ('scans', iou, 1, id, c0, c1e6, ' ', 'F'
     &, 'elliptic solver iterations', ' ', '1')
      call defvar ('hflx', iou, 1, id, -c1e20, c1e20, ' '
     &,   'F', 'global average ocean heat flux', ' ','W m-2')
      call defvar ('sflx', iou, 1, id, -c1e20, c1e20, ' '
     &,   'F', 'global average ocean salt flux', ' ','kg m-2 s-1')

      call defvar ('dicbar', iou, 1, id, c0, c100, ' ', 'F'
     &, 'Global average dic', ' ', 'mol m-3')
      call defvar ('dicflx', iou, 1, id, c0, c100, ' ', 'F'
     &, 'Global average carbon flux', ' ', 'mol m-2 s-1')

      call defvar ('motsf_max', iou, 1, id, c0, c1e20, ' '
     &, 'F', 'maximum meridional overturning streamfunction', ' '
     &, 'm3 s-1')
      call defvar ('motsf_min', iou, 1, id, c0, c1e20, ' '
     &, 'F', 'minimum meridional overturning streamfunction', ' '
     &, 'm3 s-1')

      call defvar ('slh', iou, 1, id, c0, c1e20, ' '
     &, 'F', 'relative sea level height', ' ', 'm')

!-----------------------------------------------------------------------
!     end definitions
!-----------------------------------------------------------------------
      call enddef (iou)

!-----------------------------------------------------------------------
!     close the file
!-----------------------------------------------------------------------
      call closefile (iou)

      return
      end

      subroutine mom_tsi_out (fname, avgper, relyr, stamp, ektot, tbar1
     &,                       tbar2, travar1, travar2, dtabs1, dtabs2
     &,                       scan, hflx, sflx, tbar_dic, dicflx
     &,                       tbar_alk, tbar_o2, o2flx, tbar_po4, tbar_p
     &,                       tbar_z, tbar_d, tbar_no3, tbar_di
     &,                       tbar_c14, tbar_dc14, c14flx, tbar_cfc11
     &,                       cfc11flx, tbar_cfc12, cfc12flx, otmax
     &,                       otmin, slh, ntrec)
!=======================================================================
!     output routine for ocean time step integrals

!   inputs:
!     fname      = file name
!     avgper     = length of averaging period
!     relyr      = time in years
!     stamp      = time stamp
!     ektot, ... = data to be written

!   outputs:
!     ntrec      = number of time record in file

!     based on code by: M. Eby
!=======================================================================

      implicit none

      character(*) :: fname, stamp

      integer iou, ntrec, nyear, nmonth, nday, nhour, nmin, nsec

      real ektot, tbar1, tbar2, travar1, travar2, dtabs1, dtabs2, scan
      real hflx, sflx, tbar_dic, dicflx, tbar_alk, tbar_o2, o2flx
      real tbar_po4, tbar_p, tbar_z, tbar_d, tbar_no3, tbar_di, tbar_c14
      real tbar_dc14, c14flx, tbar_cfc11, cfc11flx, tbar_cfc12, cfc12flx
      real otmax, otmin, slh, avgper, relyr, tmp, c0, c1, c100, c1e3
      real c1e6, C2K, p001, p035, p1, cal2J

      c0 = 0.
      c1 = 1.
      c100 = 100.
      c1e3 = 1.e3
      c1e6 = 1.e6
      C2K = 273.15
      p001 = 0.001
      p035 = 0.035
      p1 = 0.1
      cal2J = 2.389e-05

!-----------------------------------------------------------------------
!     open file and get latest record number
!-----------------------------------------------------------------------
      call opennext (fname, relyr, ntrec, iou)
      if (ntrec .le. 0) ntrec = 1

!-----------------------------------------------------------------------
!     write 1d data (t)
!-----------------------------------------------------------------------
      call putvars ('time', iou, ntrec, relyr, c1, c0)
      call rdstmp (stamp, nyear, nmonth, nday, nhour, nmin, nsec)
      tmp = nyear
      call putvars ('year', iou, ntrec, tmp, c1, c0)
      tmp = nmonth
      call putvars ('month', iou, ntrec, tmp, c1, c0)
      tmp = nday
      call putvars ('day', iou, ntrec, tmp, c1, c0)
      tmp = nhour
      call putvars ('hour', iou, ntrec, tmp, c1, c0)
      tmp = nmin
      call putvars ('minute', iou, ntrec, tmp, c1, c0)
      tmp = nsec
      call putvars ('second', iou, ntrec, tmp, c1, c0)
      call putvars ('period', iou, ntrec, avgper, c1, c0)
      call putvars ('ke', iou, ntrec, ektot, c100, c0)
      call putvars ('tbar', iou, ntrec, tbar1, c1, -C2K)
      call putvars ('sbar', iou, ntrec, tbar2, p001, -p035)
      tmp = 0.0
      if (travar1 .gt. 0.0) tmp = (sqrt(travar1)+273.15)**2
      call putvars ('tvar', iou, ntrec, tmp, c1, c0)
      tmp = 0.0
      if (travar2 .gt. 0.0) tmp = (sqrt(travar2)*1000.+35.)**2
      call putvars ('svar', iou, ntrec, tmp, c1, c0)
      tmp = dtabs1
      call putvars ('abs_chg_t', iou, ntrec, dtabs1, c1, c0)
      tmp = dtabs2
      call putvars ('abs_chg_s', iou, ntrec, dtabs2, p001, c0)
      call putvars ('scans', iou, ntrec, scan, c1, c0)
      call putvars ('hflx', iou, ntrec, hflx, cal2J, c0)
      call putvars ('sflx', iou, ntrec, sflx, p1, c0)

      call putvars ('dicbar', iou, ntrec, tbar_dic, c1, c0)
      call putvars ('dicflx', iou, ntrec, dicflx, c100, c0)

      call putvars ('motsf_max', iou, ntrec, otmax, c1e6, c0)
      call putvars ('motsf_min', iou, ntrec, otmin, c1e6, c0)

      call putvars ('slh', iou, ntrec, slh, c100, c0)

!-----------------------------------------------------------------------
!     close the file
!-----------------------------------------------------------------------
      call closefile (iou)

      return
      end
